/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.form.support;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormTextField;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADialogBuilder {
    public static XFormDialog buildDialog(Class<? extends Object> formClass) {
        return ADialogBuilder.buildDialog(formClass, null);
    }

    public static XFormDialog buildDialog(Class<? extends Object> formClass, ActionList actions) {
        ActionList defaultActions;
        AForm formAnnotation = formClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(formAnnotation.name());
        XForm form = builder.createForm("Basic");
        for (Field field : formClass.getFields()) {
            AField fieldAnnotation = field.getAnnotation(AField.class);
            if (fieldAnnotation == null) continue;
            ADialogBuilder.addFormField(form, fieldAnnotation);
        }
        ActionList actionList = defaultActions = formAnnotation.helpUrl().length() == 0 ? builder.buildOkCancelActions() : builder.buildOkCancelHelpActions(formAnnotation.helpUrl());
        if (actions == null) {
            actions = defaultActions;
        } else {
            actions.addActions(defaultActions);
        }
        XFormDialog dialog = builder.buildDialog(actions, formAnnotation.description(), UISupport.createImageIcon(formAnnotation.icon()));
        return dialog;
    }

    public static XFormDialog buildTabbedDialog(Class<? extends Object> tabbedFormClass, ActionList actions) {
        ActionList defaultActions;
        AForm formAnnotation = tabbedFormClass.getAnnotation(AForm.class);
        if (formAnnotation == null) {
            throw new RuntimeException("formClass is not annotated correctly..");
        }
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder(formAnnotation.name());
        for (Field field : tabbedFormClass.getFields()) {
            AField fieldAnnotation = field.getAnnotation(AField.class);
            if (fieldAnnotation == null) continue;
            XForm form = builder.createForm(fieldAnnotation.name());
            try {
                Class<?> formClass = Class.forName(fieldAnnotation.description());
                for (Field formField : formClass.getFields()) {
                    AField formFieldAnnotation = formField.getAnnotation(AField.class);
                    if (formFieldAnnotation == null) continue;
                    ADialogBuilder.addFormField(form, formFieldAnnotation);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ActionList actionList = defaultActions = formAnnotation.helpUrl().length() == 0 ? builder.buildOkCancelActions() : builder.buildOkCancelHelpActions(formAnnotation.helpUrl());
        if (actions == null) {
            actions = defaultActions;
        } else {
            actions.addActions(defaultActions);
        }
        XFormDialog dialog = builder.buildDialog(actions, formAnnotation.description(), UISupport.createImageIcon(formAnnotation.icon()));
        return dialog;
    }

    private static void addFormField(XForm form, AField fieldAnnotation) {
        XFormField field = null;
        switch (fieldAnnotation.type()) {
            case STRING: {
                field = form.addTextField(fieldAnnotation.name(), fieldAnnotation.description(), XForm.FieldType.TEXT);
                break;
            }
            case INT: {
                field = form.addTextField(fieldAnnotation.name(), fieldAnnotation.description(), XForm.FieldType.TEXT);
                ((XFormTextField)field).setWidth(10);
                break;
            }
            case STRINGAREA: {
                field = form.addTextField(fieldAnnotation.name(), fieldAnnotation.description(), XForm.FieldType.TEXTAREA);
                break;
            }
            case BOOLEAN: {
                field = form.addCheckBox(fieldAnnotation.name(), fieldAnnotation.description());
                break;
            }
            case FILE: {
                field = form.addTextField(fieldAnnotation.name(), fieldAnnotation.description(), XForm.FieldType.FILE);
                break;
            }
            case ENUMERATION: {
                field = form.addComboBox(fieldAnnotation.name(), fieldAnnotation.values(), fieldAnnotation.description());
            }
        }
        if (field != null) {
            field.setEnabled(fieldAnnotation.enabled());
        }
    }
}

