/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.desktop;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.MockServiceListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.support.WorkspaceListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.ui.desktop.DesktopListener;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSoapUIDesktop
implements SoapUIDesktop {
    private final Workspace workspace;
    private final InternalProjectListener projectListener = new InternalProjectListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private final InternalMockServiceListener mockServiceListener = new InternalMockServiceListener();
    private Set<DesktopListener> listeners = new HashSet<DesktopListener>();

    public AbstractSoapUIDesktop(Workspace workspace) {
        this.workspace = workspace;
        this.initListeners();
    }

    private void initListeners() {
        this.workspace.addWorkspaceListener(new InternalWorkspaceListener());
        for (int c = 0; c < this.workspace.getProjectCount(); ++c) {
            this.listenToProject(this.workspace.getProjectAt(c));
        }
    }

    public ActionList getActions() {
        return null;
    }

    private void listenToProject(Project project) {
        int i;
        project.addProjectListener(this.projectListener);
        for (i = 0; i < project.getInterfaceCount(); ++i) {
            project.getInterfaceAt(i).addInterfaceListener(this.interfaceListener);
        }
        for (i = 0; i < project.getTestSuiteCount(); ++i) {
            project.getTestSuiteAt(i).addTestSuiteListener(this.testSuiteListener);
        }
        for (i = 0; i < project.getMockServiceCount(); ++i) {
            project.getMockServiceAt(i).addMockServiceListener(this.mockServiceListener);
        }
    }

    public void addDesktopListener(DesktopListener listener) {
        this.listeners.add(listener);
    }

    public void removeDesktopListener(DesktopListener listener) {
        this.listeners.remove(listener);
    }

    public void closeDependantPanels(ModelItem modelItem) {
        DesktopPanel[] panels = this.getDesktopPanels();
        for (int c = 0; c < panels.length; ++c) {
            if (!panels[c].dependsOn(modelItem)) continue;
            this.closeDesktopPanel(panels[c]);
        }
    }

    protected void fireDesktopPanelCreated(DesktopPanel desktopPanel) {
        if (!this.listeners.isEmpty()) {
            DesktopListener[] array;
            for (DesktopListener listener : array = this.listeners.toArray(new DesktopListener[this.listeners.size()])) {
                listener.desktopPanelCreated(desktopPanel);
            }
        }
    }

    protected void fireDesktopPanelSelected(DesktopPanel desktopPanel) {
        if (!this.listeners.isEmpty()) {
            DesktopListener[] array;
            for (DesktopListener listener : array = this.listeners.toArray(new DesktopListener[this.listeners.size()])) {
                listener.desktopPanelSelected(desktopPanel);
            }
        }
    }

    protected void fireDesktopPanelClosed(DesktopPanel desktopPanel) {
        if (!this.listeners.isEmpty()) {
            DesktopListener[] array;
            for (DesktopListener listener : array = this.listeners.toArray(new DesktopListener[this.listeners.size()])) {
                listener.desktopPanelClosed(desktopPanel);
            }
        }
    }

    private class InternalMockServiceListener
    extends MockServiceListenerAdapter {
        private InternalMockServiceListener() {
        }

        public void mockOperationRemoved(MockOperation operation) {
            AbstractSoapUIDesktop.this.closeDependantPanels(operation);
        }

        public void mockResponseRemoved(MockResponse request) {
            AbstractSoapUIDesktop.this.closeDependantPanels(request);
        }
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testCaseRemoved(TestCase testCase) {
            AbstractSoapUIDesktop.this.closeDependantPanels(testCase);
        }

        public void testStepRemoved(TestStep testStep, int index) {
            AbstractSoapUIDesktop.this.closeDependantPanels(testStep);
        }

        public void loadTestRemoved(LoadTest loadTest) {
            AbstractSoapUIDesktop.this.closeDependantPanels(loadTest);
        }
    }

    private class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        public void operationRemoved(Operation operation) {
            AbstractSoapUIDesktop.this.closeDependantPanels(operation);
        }

        public void requestRemoved(Request request) {
            AbstractSoapUIDesktop.this.closeDependantPanels(request);
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void interfaceRemoved(Interface iface) {
            iface.removeInterfaceListener(AbstractSoapUIDesktop.this.interfaceListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(iface);
        }

        public void testSuiteRemoved(TestSuite testSuite) {
            testSuite.removeTestSuiteListener(AbstractSoapUIDesktop.this.testSuiteListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(testSuite);
        }

        public void interfaceAdded(Interface iface) {
            iface.addInterfaceListener(AbstractSoapUIDesktop.this.interfaceListener);
        }

        public void testSuiteAdded(TestSuite testSuite) {
            testSuite.addTestSuiteListener(AbstractSoapUIDesktop.this.testSuiteListener);
        }

        public void mockServiceAdded(MockService mockService) {
            mockService.addMockServiceListener(AbstractSoapUIDesktop.this.mockServiceListener);
        }

        public void mockServiceRemoved(MockService mockService) {
            mockService.removeMockServiceListener(AbstractSoapUIDesktop.this.mockServiceListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(mockService);
        }
    }

    private class InternalWorkspaceListener
    extends WorkspaceListenerAdapter {
        private InternalWorkspaceListener() {
        }

        public void projectRemoved(Project project) {
            project.removeProjectListener(AbstractSoapUIDesktop.this.projectListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(project);
        }

        public void projectAdded(Project project) {
            AbstractSoapUIDesktop.this.listenToProject(project);
        }
    }
}

