/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.SoapUITreeNodeRenderer;
import com.eviware.soapui.model.tree.nodes.ProjectTreeNode;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.ui.NavigatorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class Navigator
extends JPanel {
    private Workspace workspace;
    private JTree mainTree;
    private SoapUITreeModel treeModel;
    private Set<NavigatorListener> listeners = new HashSet<NavigatorListener>();

    public Navigator(Workspace workspace) {
        super(new BorderLayout());
        this.workspace = workspace;
        this.buildUI();
    }

    private void buildUI() {
        this.treeModel = new SoapUITreeModel(this.workspace);
        this.mainTree = new JTree(this.treeModel);
        this.mainTree.setRootVisible(true);
        this.mainTree.setExpandsSelectedPaths(true);
        this.mainTree.setToggleClickCount(0);
        this.mainTree.addMouseListener(new TreeMouseListener());
        this.mainTree.addTreeSelectionListener(new InternalTreeSelectionListener());
        this.mainTree.setCellRenderer(new SoapUITreeNodeRenderer());
        this.mainTree.setBorder(null);
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.addKeyListener(new TreeKeyListener());
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        this.add((Component)new JScrollPane(this.mainTree), "Center");
    }

    public Project getCurrentProject() {
        TreePath path = this.mainTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        while (node != null && !(node instanceof ProjectTreeNode)) {
            node = (path = path.getParentPath()) == null ? null : path.getLastPathComponent();
        }
        if (node == null) {
            return null;
        }
        return ((ProjectTreeNode)node).getProject();
    }

    public void addNavigatorListener(NavigatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeNavigatorListener(NavigatorListener listener) {
        this.listeners.remove(listener);
    }

    public void selectModelItem(ModelItem modelItem) {
        TreePath path = this.treeModel.getPath(modelItem);
        this.mainTree.setSelectionPath(path);
        this.mainTree.expandPath(path);
        this.mainTree.scrollPathToVisible(path);
    }

    public JTree getMainTree() {
        return this.mainTree;
    }

    public boolean isVisible(TreePath path) {
        return this.mainTree.isVisible(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.mainTree.isExpanded(path);
    }

    public class TreeMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else if (e.getClickCount() < 2) {
                return;
            }
            if (Navigator.this.mainTree.getSelectionCount() != 1) {
                return;
            }
            TreePath path = Navigator.this.mainTree.getSelectionPath();
            if (path == null) {
                return;
            }
            SoapUITreeNode node = (SoapUITreeNode)path.getLastPathComponent();
            ModelItem modelItem = node.getModelItem();
            ActionList actions = modelItem.getActions();
            if (actions != null) {
                actions.performDefaultAction(new ActionEvent(Navigator.this.mainTree, 0, null));
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            TreePath path = Navigator.this.mainTree.getPathForLocation((int)e.getPoint().getX(), (int)e.getPoint().getY());
            if (path == null) {
                return;
            }
            SoapUITreeNode node = (SoapUITreeNode)path.getLastPathComponent();
            JPopupMenu popupMenu = node.getPopup();
            if (popupMenu == null) {
                return;
            }
            Navigator.this.mainTree.setSelectionPath(path);
            popupMenu.show(Navigator.this.mainTree, e.getX(), e.getY());
        }
    }

    public class InternalTreeSelectionListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            Object obj = e.getPath().getLastPathComponent();
            if (obj instanceof SoapUITreeNode) {
                SoapUITreeNode treeNode = (SoapUITreeNode)obj;
                if (!Navigator.this.listeners.isEmpty()) {
                    NavigatorListener[] array;
                    TreePath newPath = e.getNewLeadSelectionPath();
                    for (NavigatorListener listener : array = Navigator.this.listeners.toArray(new NavigatorListener[Navigator.this.listeners.size()])) {
                        listener.nodeSelected(newPath == null ? null : treeNode);
                    }
                }
            }
        }
    }

    private final class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            SoapUITreeNode lastPathComponent;
            ActionList actions;
            TreePath selectionPath = Navigator.this.mainTree.getSelectionPath();
            if (selectionPath != null && (actions = (lastPathComponent = (SoapUITreeNode)selectionPath.getLastPathComponent()).getModelItem().getActions()) != null) {
                actions.dispatchKeyEvent(e);
            }
        }
    }
}

