/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceDialog;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.eviware.soapui.support.components.JEditorStatusBar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.syntax.jedit.DefaultInputHandler;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.tokenmarker.GroovyTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;

public class JXEditTextArea
extends JEditTextArea
implements UndoableEditListener,
FocusListener,
FindAndReplaceable,
JEditorStatusBar.JEditorStatusBarTarget {
    public static final int UNDO_LIMIT = 1500;
    private UndoManager undoManager;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private FindAndReplaceDialog findAndReplaceAction;
    private boolean discardEditsOnSet = true;
    private InternalSettingsListener internalSettingsListener;

    public static JXEditTextArea createXmlEditor() {
        return new JXEditTextArea(new XMLTokenMarker());
    }

    public static JXEditTextArea createGroovyEditor() {
        return new JXEditTextArea(new GroovyTokenMarker());
    }

    public JXEditTextArea(TokenMarker tokenMarker) {
        String editorFont = SoapUI.getSettings().getString(UISettings.EDITOR_FONT, "Courier plain 11");
        if (editorFont != null && editorFont.length() > 0) {
            this.getPainter().setFont(Font.decode(editorFont));
        } else {
            this.getPainter().setFont(Font.decode("Courier plain 11"));
        }
        this.getPainter().setLineHighlightColor(new Color(240, 240, 180));
        this.getPainter().setStyles(this.createXmlStyles());
        this.setTokenMarker(tokenMarker);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.getDocument().addUndoableEditListener(this);
        this.addFocusListener(this);
        this.undoAction = new UndoAction();
        this.getInputHandler().addKeyBinding("C+Z", this.undoAction);
        this.redoAction = new RedoAction();
        this.getInputHandler().addKeyBinding("C+Y", this.redoAction);
        this.findAndReplaceAction = new FindAndReplaceDialog(this);
        this.getInputHandler().addKeyBinding("C+F", this.findAndReplaceAction);
        this.getInputHandler().addKeyBinding("F3", this.findAndReplaceAction);
        this.getInputHandler().addKeyBinding("A+RIGHT", new NextElementValueAction());
        this.getInputHandler().addKeyBinding("A+LEFT", new PreviousElementValueAction());
        this.getInputHandler().addKeyBinding("C+D", new DeleteLineAction());
        this.getInputHandler().addKeyBinding("S+INSERT", this.getPasteAction());
        this.getInputHandler().addKeyBinding("S+DELETE", this.getCutAction());
        this.setMinimumSize(new Dimension(50, 50));
        this.internalSettingsListener = new InternalSettingsListener();
        SoapUI.getSettings().addSettingsListener(this.internalSettingsListener);
    }

    public Action getFindAndReplaceAction() {
        return this.findAndReplaceAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public void setText(String text) {
        if (text != null && text.equals(this.getText())) {
            return;
        }
        super.setText(text == null ? "" : text);
        if (this.discardEditsOnSet && this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    public boolean isDiscardEditsOnSet() {
        return this.discardEditsOnSet;
    }

    public void setDiscardEditsOnSet(boolean discardEditsOnSet) {
        this.discardEditsOnSet = discardEditsOnSet;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public SyntaxStyle[] createXmlStyles() {
        SyntaxStyle[] styles = new SyntaxStyle[11];
        styles[1] = new SyntaxStyle(Color.black, true, false);
        styles[2] = new SyntaxStyle(new Color(0x990033), true, false);
        styles[6] = new SyntaxStyle(Color.blue, false, false);
        styles[7] = new SyntaxStyle(Color.magenta, false, false);
        styles[8] = new SyntaxStyle(new Color(38400), false, false);
        styles[3] = new SyntaxStyle(new Color(6619289), false, false);
        styles[4] = new SyntaxStyle(new Color(6619289), false, true);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true);
        styles[9] = new SyntaxStyle(Color.black, false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        return styles;
    }

    private void createUndoMananger() {
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1500);
    }

    public void focusGained(FocusEvent fe) {
        if (this.isEditable() && this.undoManager == null) {
            this.createUndoMananger();
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.setEditable(flag);
    }

    public void setEditable(boolean enabled) {
        super.setEditable(enabled);
        this.setCaretVisible(enabled);
        this.getPainter().setLineHighlightEnabled(enabled);
        this.repaint();
    }

    public void focusLost(FocusEvent fe) {
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.undoManager != null) {
            this.undoManager.addEdit(e.getEdit());
        }
    }

    public Action getCopyAction() {
        return DefaultInputHandler.CLIP_COPY;
    }

    public Action getCutAction() {
        return DefaultInputHandler.CLIP_CUT;
    }

    public Action getPasteAction() {
        return DefaultInputHandler.CLIP_PASTE;
    }

    public int getCaretColumn() {
        int pos = this.getCaretPosition();
        int line = this.getLineOfOffset(pos);
        return pos - this.getLineStartOffset(line);
    }

    public void toNextElement() {
        String text = this.getText();
        for (int pos = this.getCaretPosition(); pos < text.length(); ++pos) {
            if (text.charAt(pos) != '>' || pos >= text.length() - 1 || pos <= 2 || text.substring(pos - 2, pos).equals("--") || pos <= 1 || text.charAt(pos - 1) == '/' || text.indexOf(47, pos) != text.indexOf(60, pos) + 1 || text.lastIndexOf(47, pos) == text.lastIndexOf(60, pos) + 1) continue;
            this.setCaretPosition(pos + 1);
            return;
        }
        this.getToolkit().beep();
    }

    public void toPreviousElement() {
        String text = this.getText();
        for (int pos = this.getCaretPosition() - 2; pos > 0; --pos) {
            if (text.charAt(pos) != '>' || pos >= text.length() - 1 || pos <= 2 || text.substring(pos - 2, pos).equals("--") || pos <= 1 || text.charAt(pos - 1) == '/' || text.indexOf(47, pos) != text.indexOf(60, pos) + 1 || text.lastIndexOf(47, pos) == text.lastIndexOf(60, pos) + 1) continue;
            this.setCaretPosition(pos + 1);
            return;
        }
        this.getToolkit().beep();
    }

    public class DeleteLineAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (!JXEditTextArea.this.isEditable()) {
                JXEditTextArea.this.getToolkit().beep();
                return;
            }
            int caretLine = JXEditTextArea.this.getCaretLine();
            if (caretLine == -1) {
                return;
            }
            int lineStartOffset = JXEditTextArea.this.getLineStartOffset(caretLine);
            int lineEndOffset = JXEditTextArea.this.getLineEndOffset(caretLine);
            try {
                int len = lineEndOffset - lineStartOffset;
                if (lineStartOffset + len >= JXEditTextArea.this.getDocumentLength()) {
                    len = JXEditTextArea.this.getDocumentLength() - lineStartOffset;
                }
                JXEditTextArea.this.getDocument().remove(lineStartOffset, len);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    public class PreviousElementValueAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JXEditTextArea.this.toPreviousElement();
        }
    }

    public class NextElementValueAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JXEditTextArea.this.toNextElement();
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Y"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!JXEditTextArea.this.isEditable()) {
                JXEditTextArea.this.getToolkit().beep();
                return;
            }
            try {
                if (JXEditTextArea.this.undoManager != null) {
                    JXEditTextArea.this.undoManager.redo();
                }
            }
            catch (CannotRedoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Z"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!JXEditTextArea.this.isEditable()) {
                JXEditTextArea.this.getToolkit().beep();
                return;
            }
            try {
                if (JXEditTextArea.this.undoManager != null) {
                    JXEditTextArea.this.undoManager.undo();
                }
            }
            catch (CannotUndoException cue) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private InternalSettingsListener() {
        }

        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(UISettings.EDITOR_FONT)) {
                JXEditTextArea.this.getPainter().setFont(Font.decode(newValue));
                JXEditTextArea.this.invalidate();
            }
        }
    }
}

