/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPropertiesTable<T>
extends JPanel {
    public static final Object[] BOOLEAN_OPTIONS = new Object[]{Boolean.TRUE, Boolean.FALSE};
    private PropertiesTableModel<T> tableModel;
    private JTable table;

    public JPropertiesTable(String title) {
        this(title, null);
    }

    public JPropertiesTable(String title, T propertyObject) {
        super(new BorderLayout());
        this.tableModel = new PropertiesTableModel<T>(propertyObject);
        this.table = new PTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setHeaderValue("Property");
        this.table.getColumnModel().getColumn(1).setHeaderValue("Value");
        this.table.getColumnModel().getColumn(0).setCellRenderer(new PropertiesTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new PropertiesTableCellRenderer());
        this.add((Component)new JScrollPane(this.table), "Center");
        if (title != null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), title);
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(0, 11.0f));
            this.setBorder(titledBorder);
        }
        this.table.setBackground(Color.WHITE);
        this.setPreferredSize(this.table.getPreferredSize());
    }

    public void setPropertyObject(T propertyObject) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.setPropertyObject(propertyObject);
    }

    public PropertiesTableModel getTableModel() {
        return this.tableModel;
    }

    public void addProperty(String caption, String name) {
        this.addProperty(caption, name, false);
    }

    public void addProperty(String caption, String name, boolean editable) {
        this.addProperty(caption, name, editable, null);
    }

    public void addProperty(String caption, String name, boolean editable, PropertyFormatter formatter) {
        this.tableModel.addProperty(caption, name, editable, formatter);
    }

    public void addProperty(String caption, String name, Object[] options) {
        this.tableModel.addProperty(caption, name, options);
    }

    private class PTable
    extends JTable {
        public PTable(TableModel tableModel) {
            super(tableModel);
            this.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    int row = PTable.this.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    StringSelection selection = new StringSelection(PTable.this.getValueAt(row, 1).toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
                }
            });
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return super.getCellEditor(row, column);
            }
            return JPropertiesTable.this.tableModel.getPropertyDescriptorAt(row).getCellEditor();
        }
    }

    private static class DefaultFormatter
    implements PropertyFormatter {
        private static PropertyFormatter instance;

        private DefaultFormatter() {
        }

        public static PropertyFormatter getInstance() {
            if (instance == null) {
                instance = new DefaultFormatter();
            }
            return instance;
        }

        public Object format(String propertyName, Object value) {
            return value;
        }
    }

    public static interface PropertyFormatter {
        public Object format(String var1, Object var2);
    }

    private static class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        private PropertiesTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JComponent && value != null) {
                ((JComponent)component).setToolTipText(value.toString());
            }
            return component;
        }
    }

    private static class PropertyDescriptor {
        private final String caption;
        private final String name;
        private boolean editable;
        private PropertyFormatter formatter;
        private Object[] options;
        private DefaultCellEditor cellEditor;

        public PropertyDescriptor(String caption, String name, boolean editable, PropertyFormatter formatter) {
            this.caption = caption;
            this.name = name;
            this.editable = editable;
            this.formatter = formatter;
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createEmptyBorder());
            this.cellEditor = new DefaultCellEditor(textField);
        }

        public PropertyDescriptor(String caption, String name, Object[] options) {
            this.caption = caption;
            this.name = name;
            this.options = options;
            this.editable = true;
            JComboBox<Object> comboBox = new JComboBox<Object>(options);
            if (options[0] == null) {
                comboBox.setEditable(true);
                comboBox.removeItemAt(0);
            }
            comboBox.setBorder(null);
            this.cellEditor = new DefaultCellEditor(comboBox);
        }

        public void setFormatter(PropertyFormatter formatter) {
            this.formatter = formatter;
        }

        public PropertyFormatter getFormatter() {
            return this.formatter == null ? DefaultFormatter.getInstance() : this.formatter;
        }

        public String getCaption() {
            return this.caption;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public Object[] getOptions() {
            return this.options;
        }

        public boolean hasOptions() {
            return this.options != null;
        }

        public String getName() {
            return this.name;
        }

        public TableCellEditor getCellEditor() {
            return this.cellEditor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertiesTableModel<T>
    extends AbstractTableModel
    implements PropertyChangeListener {
        private List<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        private T propertyObject;

        public PropertiesTableModel(T propertyObject) {
            this.propertyObject = propertyObject;
        }

        public void setPropertyObject(T propertyObject) {
            this.propertyObject = propertyObject;
            this.fireTableDataChanged();
        }

        public void addProperty(String caption, String name, boolean editable, PropertyFormatter formatter) {
            this.properties.add(new PropertyDescriptor(caption, name, editable, formatter));
        }

        public void addProperty(String caption, String name, Object[] options) {
            this.properties.add(new PropertyDescriptor(caption, name, options));
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || this.propertyObject == null) {
                return false;
            }
            return this.properties.get(rowIndex).isEditable() && PropertyUtils.isWriteable(this.propertyObject, (String)this.properties.get(rowIndex).getName());
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                if (this.propertyObject != null && columnIndex == 1 && this.properties.get(rowIndex).isEditable()) {
                    PropertyUtils.setSimpleProperty(this.propertyObject, (String)this.properties.get(rowIndex).getName(), (Object)aValue);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.propertyObject == null) {
                return null;
            }
            try {
                PropertyDescriptor propertyDescriptor = this.properties.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return propertyDescriptor.getCaption();
                    }
                    case 1: {
                        Object value = PropertyUtils.getSimpleProperty(this.propertyObject, (String)propertyDescriptor.getName());
                        return propertyDescriptor.getFormatter().format(propertyDescriptor.getName(), value);
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return null;
        }

        public PropertyDescriptor getPropertyDescriptorAt(int row) {
            return this.properties.get(row);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.lastIndexOf(64) > 0) {
                name = name.substring(name.lastIndexOf(64) + 1);
            }
            for (int c = 0; c < this.properties.size(); ++c) {
                if (!this.properties.get(c).getName().equals(name)) continue;
                this.fireTableCellUpdated(c, 1);
                return;
            }
        }
    }
}

