/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Timestamps {
    private static ThreadLocal<Timestamps> timestamps = new ThreadLocal();
    private List<String> labels = new ArrayList<String>();
    private List<Long> times = new ArrayList<Long>();
    private long startTime = System.nanoTime();

    private Timestamps() {
    }

    public static void init() {
        timestamps.set(new Timestamps());
    }

    public static void addTimestamp(String label) {
        timestamps.get().add(label);
    }

    public static synchronized void dump() {
        timestamps.get().dumpResult(System.out);
    }

    public static void dump(PrintStream out) {
        timestamps.get().dumpResult(out);
    }

    private void add(String label) {
        this.times.add(System.nanoTime());
        this.labels.add(label);
    }

    private void dumpResult(PrintStream out) {
        out.println("Timestamps result:");
        long last = this.startTime;
        for (int c = 0; c < this.labels.size(); ++c) {
            out.println(this.labels.get(c) + "; " + (this.times.get(c) - this.startTime) / 1000000L);
            last = this.times.get(c);
        }
    }

    public static long getTimeTaken() {
        return timestamps.get().getInternalTimeTaken();
    }

    private long getInternalTimeTaken() {
        if (this.labels.isEmpty()) {
            return 0L;
        }
        return (this.times.get(this.times.size() - 1) - this.startTime) / 1000000L;
    }
}

