/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.RequestTreeNode;
import com.eviware.soapui.settings.UISettings;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationTreeNode
extends AbstractModelItemTreeNode<Operation> {
    private List<RequestTreeNode> requestNodes = new ArrayList<RequestTreeNode>();
    private AbstractModelItemTreeNode.ReorderPropertyChangeListener propertyChangeListener = new AbstractModelItemTreeNode.ReorderPropertyChangeListener();

    public OperationTreeNode(Operation operation, SoapUITreeModel treeModel) {
        super(operation, operation.getInterface(), treeModel);
        for (int c = 0; c < operation.getRequestCount(); ++c) {
            Request request = operation.getRequestAt(c);
            request.addPropertyChangeListener(Request.NAME_PROPERTY, this.propertyChangeListener);
            this.requestNodes.add(new RequestTreeNode(request, this.getTreeModel()));
        }
        this.initOrdering(this.requestNodes, UISettings.ORDER_REQUESTS);
        treeModel.mapModelItems(this.requestNodes);
    }

    @Override
    public void release() {
        super.release();
        for (RequestTreeNode treeNode : this.requestNodes) {
            treeNode.release();
        }
    }

    public Operation getOperation() {
        return (Operation)this.getModelItem();
    }

    public void requestAdded(Request request) {
        RequestTreeNode requestTreeNode = new RequestTreeNode(request, this.getTreeModel());
        this.requestNodes.add(requestTreeNode);
        this.reorder(false);
        request.addPropertyChangeListener(Request.NAME_PROPERTY, this.propertyChangeListener);
        this.getTreeModel().notifyNodeInserted(requestTreeNode);
    }

    public void requestRemoved(Request request) {
        SoapUITreeNode requestTreeNode = this.getTreeModel().getTreeNode(request);
        if (!this.requestNodes.contains(requestTreeNode)) {
            throw new RuntimeException("Removing unkown request");
        }
        this.getTreeModel().notifyNodeRemoved(requestTreeNode);
        this.requestNodes.remove(requestTreeNode);
        request.removePropertyChangeListener(this.propertyChangeListener);
    }
}

