/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions;

import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionException;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.ResponseAssertion;
import com.eviware.soapui.model.iface.SubmitContext;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class NotSoapFaultAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "SOAP Fault Assertion";
    public static final String LABEL = "Not SOAP Fault";

    public NotSoapFaultAssertion(RequestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
    }

    public String internalAssertResponse(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        String responseContent = messageExchange.getResponseContent();
        try {
            if (responseContent.indexOf(":Fault") > 0 || responseContent.indexOf("<Fault") > 0) {
                SoapVersion soapVersion = messageExchange.getOperation().getInterface().getSoapVersion();
                XmlObject xml = XmlObject.Factory.parse((String)responseContent);
                XmlObject[] paths = xml.selectPath("declare namespace env='" + soapVersion.getEnvelopeNamespace() + "';" + "//env:Fault");
                if (paths.length > 0) {
                    throw new AssertionException(new AssertionError("Response is a SOAP Fault"));
                }
            }
        }
        catch (XmlException e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        return "Response is not a SOAP Fault";
    }

    protected String internalAssertRequest(WsdlMessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }
}

