/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.CloneTestStepAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class WsdlDelayTestStep
extends WsdlTestStep {
    private static final int DEFAULT_DELAY = 1000;
    private static final int DELAY_CHUNK = 100;
    private int delay = 1000;
    private int timeWaited = 0;
    private boolean canceled;

    public WsdlDelayTestStep(WsdlTestCase testCase, TestStepConfig config) {
        super(testCase, config, false);
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new SetWaitTimeAction(), true);
        this.addAction(new CloneTestStepAction(this, "DelayStep"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testcases.html#Delay_Test_Step"));
        this.setIcon(UISupport.createImageIcon("/wait.gif"));
        if (config.getConfig() == null) {
            this.saveDelay(config);
        } else {
            this.readConfig(config);
        }
    }

    private void readConfig(TestStepConfig config) {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config.getConfig());
        this.delay = reader.readInt("delay", 1000);
    }

    public String getName() {
        return super.getName() + " [" + (this.delay - this.timeWaited) + "ms]";
    }

    private void saveDelay(TestStepConfig config) {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("delay", this.delay);
        config.setConfig(builder.finish());
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.readConfig(config);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        if (this.delay == delay) {
            return;
        }
        String oldName = this.getName();
        this.delay = delay;
        this.saveDelay((TestStepConfig)this.getConfig());
        this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, this.getName());
    }

    public TestStepResult run(TestRunner testRunner, TestRunContext context) {
        WsdlTestStepResult result = new WsdlTestStepResult(this);
        result.startTimer();
        String oldName = this.getName();
        try {
            this.canceled = false;
            this.timeWaited = 0;
            while (!this.canceled && this.timeWaited < this.delay) {
                if (this.timeWaited % 1000 == 0 && context.getProperty("LoadTestRunner") == null) {
                    this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, this.getName());
                    oldName = this.getName();
                }
                if (this.timeWaited <= this.delay - 100) {
                    Thread.sleep(100L);
                } else {
                    Thread.sleep(this.delay % 100);
                }
                this.timeWaited += 100;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        result.stopTimer();
        result.setStatus(this.canceled ? TestStepResult.TestStepStatus.CANCELED : TestStepResult.TestStepStatus.OK);
        this.timeWaited = 0;
        if (context.getProperty("LoadTestRunner") == null) {
            this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, this.getName());
        }
        return result;
    }

    public boolean cancel() {
        this.canceled = true;
        return true;
    }

    private class SetWaitTimeAction
    extends AbstractAction {
        public SetWaitTimeAction() {
            super("Set Delay Time");
        }

        public void actionPerformed(ActionEvent e) {
            String value = UISupport.prompt("Specify delay in milliseconds", "Set Delay", String.valueOf(WsdlDelayTestStep.this.delay));
            if (value != null) {
                try {
                    WsdlDelayTestStep.this.setDelay(Integer.parseInt(value));
                }
                catch (NumberFormatException e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }
}

