/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.support.swing.SwingWorker;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.GetMethod;

public class UrlWsdlLoader
extends WsdlLoader {
    private HttpState state;
    private GetMethod getMethod;
    private boolean aborted;
    private Map<String, byte[]> wsdlCache = new HashMap<String, byte[]>();
    private boolean finished;

    public UrlWsdlLoader(String url) {
        super(url);
        this.state = new HttpState();
    }

    public synchronized InputStream load(String url) throws Exception {
        if (this.wsdlCache.containsKey(url)) {
            return new ByteArrayInputStream(this.wsdlCache.get(url));
        }
        if (url.startsWith("file:")) {
            return new URL(url).openStream();
        }
        log.debug((Object)("Getting wsdl component from [" + url + "]"));
        this.createGetMethod(url);
        if (this.aborted) {
            return null;
        }
        LoaderWorker worker = new LoaderWorker();
        worker.start();
        while (!this.aborted && !this.finished) {
            Thread.sleep(200L);
        }
        while (!this.aborted && this.getMethod.getResponseBody() == null) {
            Thread.sleep(200L);
        }
        try {
            if (this.aborted) {
                throw new Exception("Load of url [" + url + "] was aborted");
            }
            byte[] content = this.getMethod.getResponseBody();
            if (content != null) {
                if (HttpClientSupport.isZippedResponse((HttpMethodBase)this.getMethod)) {
                    content = HttpClientSupport.decompress(content);
                }
                this.wsdlCache.put(url, content);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
                return byteArrayInputStream;
            }
            throw new Exception("Failed to load url; " + this.getMethod.getStatusCode() + " - " + this.getMethod.getStatusText());
        }
        finally {
            this.getMethod.releaseConnection();
        }
    }

    private void createGetMethod(String url) {
        this.getMethod = new GetMethod(url);
        this.getMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new WsdlCredentialsProvider());
        this.getMethod.setDoAuthentication(true);
    }

    public boolean abort() {
        if (this.getMethod != null) {
            this.getMethod.abort();
        }
        this.aborted = true;
        return true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void close() {
    }

    public static final class WsdlCredentialsProvider
    implements CredentialsProvider {
        private XFormDialog basicDialog;
        private XFormDialog ntDialog;
        private XFormDialog dialog;
        public boolean canceled;

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            if (authscheme == null) {
                return null;
            }
            try {
                if (authscheme instanceof NTLMScheme) {
                    WsdlLoader.log.info((Object)(host + ":" + port + " requires Windows authentication"));
                    if (this.ntDialog == null) {
                        this.buildNtDialog();
                    }
                    this.dialog = this.ntDialog;
                    StringToStringMap values = new StringToStringMap();
                    values.put("Info", "Authentication required for [" + host + ":" + port + "]");
                    this.ntDialog.setValues(values);
                    this.ntDialog.setVisible(true);
                    if (this.canceled) {
                        throw new CredentialsNotAvailableException("Operation cancelled");
                    }
                    values = this.ntDialog.getValues();
                    return new NTCredentials((String)values.get("Username"), (String)values.get("Password"), host, (String)values.get("Domain"));
                }
                if (authscheme instanceof RFC2617Scheme) {
                    WsdlLoader.log.info((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'"));
                    if (this.basicDialog == null) {
                        this.buildBasicDialog();
                    }
                    this.dialog = this.basicDialog;
                    StringToStringMap values = new StringToStringMap();
                    values.put("Info", "Authentication required for [" + host + ":" + port + "]");
                    this.basicDialog.setValues(values);
                    this.basicDialog.setVisible(true);
                    if (this.canceled) {
                        throw new CredentialsNotAvailableException("Operation cancelled");
                    }
                    values = this.basicDialog.getValues();
                    return new UsernamePasswordCredentials((String)values.get("Username"), (String)values.get("Password"));
                }
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }

        private void buildBasicDialog() {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Basic Authentication");
            XForm mainForm = builder.createForm("Basic");
            mainForm.addLabel("Info", "");
            mainForm.addTextField("Username", "Username for authentication", XForm.FieldType.TEXT);
            mainForm.addTextField("Password", "Password for authentication", XForm.FieldType.PASSWORD);
            this.basicDialog = builder.buildDialog(this.buildDefaultActions(), "Specify Basic Authentication Credentials", UISupport.OPTIONS_ICON);
        }

        private void buildNtDialog() {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("NT Authentication");
            XForm mainForm = builder.createForm("Basic");
            mainForm.addLabel("Info", "");
            mainForm.addTextField("Username", "Username for authentication", XForm.FieldType.TEXT);
            mainForm.addTextField("Password", "Password for authentication", XForm.FieldType.PASSWORD);
            mainForm.addTextField("Domain", "NT Domain for authentication", XForm.FieldType.TEXT);
            this.ntDialog = builder.buildDialog(this.buildDefaultActions(), "Specify NT Authentication Credentials", UISupport.OPTIONS_ICON);
        }

        public ActionList buildDefaultActions() {
            DefaultActionList actions = new DefaultActionList("Actions");
            actions.addAction(new OkAction());
            actions.addAction(new CancelAction());
            return actions;
        }

        public void closeDialog() {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
        }

        protected final class OkAction
        extends AbstractAction {
            public OkAction() {
                super("OK");
            }

            public void actionPerformed(ActionEvent e) {
                WsdlCredentialsProvider.this.canceled = false;
                WsdlCredentialsProvider.this.closeDialog();
            }
        }

        protected final class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super("Cancel");
            }

            public void actionPerformed(ActionEvent e) {
                WsdlCredentialsProvider.this.canceled = true;
                WsdlCredentialsProvider.this.closeDialog();
            }
        }
    }

    private final class LoaderWorker
    extends SwingWorker {
        private LoaderWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            HttpClient httpClient = HttpClientSupport.getHttpClient();
            try {
                Settings soapuiSettings = SoapUI.getSettings();
                HttpClientSupport.applyHttpSettings((HttpMethodBase)UrlWsdlLoader.this.getMethod, soapuiSettings);
                HostConfiguration hostConfiguration = ProxyUtils.initProxySettings(soapuiSettings, UrlWsdlLoader.this.state, new HostConfiguration(), UrlWsdlLoader.this.getMethod.getURI().toString());
                httpClient.executeMethod(hostConfiguration, (HttpMethod)UrlWsdlLoader.this.getMethod, UrlWsdlLoader.this.state);
            }
            catch (Exception e) {
                Exception exception = e;
                return exception;
            }
            finally {
                UrlWsdlLoader.this.finished = true;
            }
            return null;
        }
    }
}

