/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.support.xsd.SampleXmlUtil;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessageBuilder;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageBuilder
implements MessageBuilder {
    private static final Logger log = Logger.getLogger(SoapMessageBuilder.class);
    private WsdlContext wsdlContext;
    private WsdlInterface iface;

    public SoapMessageBuilder(WsdlInterface iface) throws Exception {
        this.iface = iface;
        this.wsdlContext = iface.getWsdlContext();
    }

    public SoapMessageBuilder(WsdlContext wsdlContext) {
        this.wsdlContext = wsdlContext;
    }

    @Override
    public Interface getInterface() {
        return this.iface;
    }

    public String buildFault(String faultcode, String faultstring) {
        SampleXmlUtil generator = new SampleXmlUtil(false);
        generator.setTypeComment(false);
        generator.setIgnoreOptional(true);
        String emptyResponse = this.buildEmptyFault(generator);
        emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//faultcode", faultcode);
        emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//faultstring", faultstring);
        return emptyResponse;
    }

    public String buildEmptyFault() {
        SampleXmlUtil generator = new SampleXmlUtil(false);
        String emptyResponse = this.buildEmptyFault(generator);
        return emptyResponse;
    }

    private String buildEmptyFault(SampleXmlUtil generator) {
        SoapVersion soapVersion = this.iface.getSoapVersion();
        String emptyResponse = this.iface.getMessageBuilder().buildEmptyMessage();
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((String)emptyResponse);
            XmlCursor cursor = xmlObject.newCursor();
            if (cursor.toChild(soapVersion.getEnvelopeQName()) && cursor.toChild(soapVersion.getBodyQName())) {
                SchemaType faultType = soapVersion.getFaultType();
                Node bodyNode = cursor.getDomNode();
                Document dom = XmlUtils.parseXml(generator.createSample(faultType));
                bodyNode.appendChild(bodyNode.getOwnerDocument().importNode(dom.getDocumentElement(), true));
            }
            cursor.dispose();
            emptyResponse = xmlObject.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return emptyResponse;
    }

    public String buildEmptyMessage() {
        SampleXmlUtil generator = new SampleXmlUtil(false);
        generator.setTypeComment(false);
        generator.setIgnoreOptional(true);
        return generator.createSample(this.iface.getSoapVersion().getEnvelopeType());
    }

    @Override
    public Request buildRequest(Operation operation, Map params) {
        return null;
    }

    public String buildSoapRequest(BindingOperation bindingOperation, boolean buildOptional) throws Exception {
        boolean inputSoapEncoded = WsdlUtils.isInputSoapEncoded(bindingOperation);
        SampleXmlUtil xmlGenerator = new SampleXmlUtil(inputSoapEncoded);
        xmlGenerator.setIgnoreOptional(!buildOptional);
        XmlObject object = XmlObject.Factory.newInstance();
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        cursor.beginElement(this.wsdlContext.getSoapVersion().getEnvelopeQName());
        if (inputSoapEncoded) {
            cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            cursor.insertNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        }
        cursor.toFirstChild();
        cursor.beginElement(this.wsdlContext.getSoapVersion().getBodyQName());
        cursor.toFirstChild();
        if (WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation)) {
            this.buildRpcRequest(bindingOperation, cursor, xmlGenerator);
        } else {
            this.buildDocumentRequest(bindingOperation, cursor, xmlGenerator);
        }
        this.addHeaders(WsdlUtils.getSoapHeaders(bindingOperation.getBindingInput().getExtensibilityElements()), cursor, xmlGenerator);
        cursor.dispose();
        try {
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(object, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return object.xmlText();
        }
    }

    private void buildMultipartRequest(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        this.buildDocumentRequest(bindingOperation, cursor, xmlGenerator);
    }

    private void addHeaders(List<WsdlUtils.SoapHeader> headers, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        cursor.toStartDoc();
        cursor.toChild(this.wsdlContext.getSoapVersion().getEnvelopeQName());
        cursor.toFirstChild();
        cursor.beginElement(this.wsdlContext.getSoapVersion().getHeaderQName());
        cursor.toFirstChild();
        for (int i = 0; i < headers.size(); ++i) {
            WsdlUtils.SoapHeader header = headers.get(i);
            Message message = this.wsdlContext.getDefinition().getMessage(header.getMessage());
            if (message == null) {
                log.error((Object)("Missing message for header: " + header.getMessage()));
                continue;
            }
            Part part = message.getPart(header.getPart());
            if (part != null) {
                this.createElementForPart(part, cursor, xmlGenerator);
                continue;
            }
            log.error((Object)("Missing part for header; " + header.getPart()));
        }
    }

    public void createElementForPart(Part part, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        QName elementName = part.getElementName();
        QName typeName = part.getTypeName();
        if (elementName != null) {
            cursor.beginElement(elementName);
            if (this.wsdlContext.hasSchemaTypes()) {
                SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
                if (elm != null) {
                    cursor.toFirstChild();
                    xmlGenerator.createSampleForType(elm.getType(), cursor);
                } else {
                    log.error((Object)("Could not find element [" + elementName + "] specified in part [" + part.getName() + "]"));
                }
            }
            cursor.toParent();
        } else {
            cursor.beginElement(new QName(this.wsdlContext.getDefinition().getTargetNamespace(), part.getName()));
            if (typeName != null && this.wsdlContext.hasSchemaTypes()) {
                SchemaType type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    cursor.toFirstChild();
                    xmlGenerator.createSampleForType(type, cursor);
                } else {
                    log.error((Object)("Could not find type [" + typeName + "] specified in part [" + part.getName() + "]"));
                }
            }
            cursor.toParent();
        }
    }

    private void buildDocumentRequest(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        Part[] parts = WsdlUtils.getInputParts(bindingOperation);
        for (int i = 0; i < parts.length; ++i) {
            if (WsdlUtils.isAttachmentInputPart(parts[i], bindingOperation)) continue;
            XmlCursor c = cursor.newCursor();
            c.toLastChild();
            this.createElementForPart(parts[i], c, xmlGenerator);
            c.dispose();
        }
    }

    private void buildDocumentResponse(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        Part[] parts = WsdlUtils.getOutputParts(bindingOperation);
        for (int i = 0; i < parts.length; ++i) {
            if (WsdlUtils.isAttachmentOutputPart(parts[i], bindingOperation)) continue;
            XmlCursor c = cursor.newCursor();
            c.toLastChild();
            this.createElementForPart(parts[i], c, xmlGenerator);
            c.dispose();
        }
    }

    private void buildRpcRequest(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        String ns = WsdlUtils.getSoapBodyNamespace(bindingOperation.getBindingInput().getExtensibilityElements());
        if (ns == null) {
            ns = this.wsdlContext.getDefinition().getTargetNamespace();
            log.warn((Object)"missing namespace on soapbind:body, using targetNamespace instead (BP violation)");
        }
        cursor.beginElement(new QName(ns, bindingOperation.getName()));
        if (xmlGenerator.isSoapEnc()) {
            cursor.insertAttributeWithValue(new QName(this.wsdlContext.getSoapVersion().getEnvelopeNamespace(), "encodingStyle"), this.wsdlContext.getSoapVersion().getEncodingNamespace());
        }
        Part[] inputParts = WsdlUtils.getInputParts(bindingOperation);
        for (int i = 0; i < inputParts.length; ++i) {
            XmlCursor c;
            Part part = inputParts[i];
            if (WsdlUtils.isAttachmentInputPart(part, bindingOperation)) {
                if (!this.iface.getSettings().getBoolean(WsdlSettings.ATTACHMENT_PARTS)) continue;
                XmlCursor c2 = cursor.newCursor();
                c2.toLastChild();
                c2.beginElement(part.getName());
                c2.insertAttributeWithValue("href", part.getName() + "Attachment");
                c2.dispose();
                continue;
            }
            if (!this.wsdlContext.hasSchemaTypes()) continue;
            QName typeName = part.getTypeName();
            if (typeName != null) {
                SchemaType type = this.wsdlContext.findType(typeName);
                if (type != null) {
                    c = cursor.newCursor();
                    c.toLastChild();
                    c.insertElement(part.getName());
                    c.toPrevToken();
                    xmlGenerator.createSampleForType(type, c);
                    c.dispose();
                    continue;
                }
                log.warn((Object)("Failed to find type [" + typeName + "]"));
                continue;
            }
            SchemaGlobalElement element = this.wsdlContext.getSchemaTypeLoader().findElement(part.getElementName());
            if (element != null) {
                c = cursor.newCursor();
                c.toLastChild();
                c.insertElement(element.getName());
                c.toPrevToken();
                xmlGenerator.createSampleForType(element.getType(), c);
                c.dispose();
                continue;
            }
            log.warn((Object)("Failed to find element [" + part.getElementName() + "]"));
        }
    }

    private void buildRpcResponse(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        String ns = WsdlUtils.getSoapBodyNamespace(bindingOperation.getBindingOutput().getExtensibilityElements());
        if (ns == null) {
            ns = this.wsdlContext.getDefinition().getTargetNamespace();
            log.warn((Object)"missing namespace on soapbind:body, using targetNamespace instead (BP violation)");
        }
        cursor.beginElement(new QName(ns, bindingOperation.getName() + "Response"));
        if (xmlGenerator.isSoapEnc()) {
            cursor.insertAttributeWithValue(new QName(this.wsdlContext.getSoapVersion().getEnvelopeNamespace(), "encodingStyle"), this.wsdlContext.getSoapVersion().getEncodingNamespace());
        }
        Part[] inputParts = WsdlUtils.getOutputParts(bindingOperation);
        for (int i = 0; i < inputParts.length; ++i) {
            XmlCursor c;
            Part part = inputParts[i];
            if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) {
                if (!this.iface.getSettings().getBoolean(WsdlSettings.ATTACHMENT_PARTS)) continue;
                XmlCursor c2 = cursor.newCursor();
                c2.toLastChild();
                c2.beginElement(part.getName());
                c2.insertAttributeWithValue("href", part.getName() + "Attachment");
                c2.dispose();
                continue;
            }
            if (!this.wsdlContext.hasSchemaTypes()) continue;
            QName typeName = part.getTypeName();
            if (typeName != null) {
                SchemaType type = this.wsdlContext.findType(typeName);
                if (type != null) {
                    c = cursor.newCursor();
                    c.toLastChild();
                    c.insertElement(part.getName());
                    c.toPrevToken();
                    xmlGenerator.createSampleForType(type, c);
                    c.dispose();
                    continue;
                }
                log.warn((Object)("Failed to find type [" + typeName + "]"));
                continue;
            }
            SchemaGlobalElement element = this.wsdlContext.getSchemaTypeLoader().findElement(part.getElementName());
            if (element != null) {
                c = cursor.newCursor();
                c.toLastChild();
                c.insertElement(element.getName());
                c.toPrevToken();
                xmlGenerator.createSampleForType(element.getType(), c);
                c.dispose();
                continue;
            }
            log.warn((Object)("Failed to find element [" + part.getElementName() + "]"));
        }
    }

    public void setWsdlContext(WsdlContext wsdlContext) {
        this.wsdlContext = wsdlContext;
    }

    public void setInterface(WsdlInterface iface) {
        this.iface = iface;
    }

    public String buildSoapResponse(BindingOperation bindingOperation, boolean buildOptional) throws Exception {
        boolean inputSoapEncoded = WsdlUtils.isInputSoapEncoded(bindingOperation);
        SampleXmlUtil xmlGenerator = new SampleXmlUtil(inputSoapEncoded);
        xmlGenerator.setIgnoreOptional(!buildOptional);
        XmlObject object = XmlObject.Factory.newInstance();
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        cursor.beginElement(this.wsdlContext.getSoapVersion().getEnvelopeQName());
        if (inputSoapEncoded) {
            cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            cursor.insertNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        }
        cursor.toFirstChild();
        cursor.beginElement(this.wsdlContext.getSoapVersion().getBodyQName());
        cursor.toFirstChild();
        if (WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation)) {
            this.buildRpcResponse(bindingOperation, cursor, xmlGenerator);
        } else {
            this.buildDocumentResponse(bindingOperation, cursor, xmlGenerator);
        }
        this.addHeaders(WsdlUtils.getSoapHeaders(bindingOperation.getBindingOutput().getExtensibilityElements()), cursor, xmlGenerator);
        cursor.dispose();
        try {
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(object, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return object.xmlText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildFault(MessagePart.FaultPart faultPart) {
        SampleXmlUtil generator = new SampleXmlUtil(false);
        generator.setExampleContent(false);
        generator.setTypeComment(false);
        String faultResponse = this.iface.getMessageBuilder().buildEmptyFault();
        XmlCursor cursor = null;
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((String)faultResponse);
            XmlObject[] detail = xmlObject.selectPath("//detail");
            cursor = detail[0].newCursor();
            cursor.toFirstContentToken();
            generator.setTypeComment(true);
            generator.setIgnoreOptional(this.iface.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS));
            for (Part part : faultPart.getWsdlParts()) {
                this.createElementForPart(part, cursor, generator);
            }
            faultResponse = xmlObject.xmlText(new XmlOptions().setSaveAggressiveNamespaces().setSavePrettyPrint());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return faultResponse;
    }
}

