/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.log4j.Logger;

public class StripWhitespacesRequestFilter
implements RequestFilter {
    private static final Logger log = Logger.getLogger(PropertyExpansionRequestFilter.class);

    public void filterRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        if (!wsdlRequest.isStripWhitespaces()) {
            return;
        }
        String content = (String)context.getProperty("requestContent");
        if (content == null) {
            log.warn((Object)"Missing request content in context, skipping stripWhitespaces");
        } else {
            content = XmlUtils.stripWhitespaces(content);
            context.setProperty("requestContent", content);
        }
    }
}

