/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsdlRequestCredentialsProvider;
import com.eviware.soapui.impl.wsdl.submit.transports.http.TimeablePostMethod;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class HttpAuthenticationRequestFilter
implements RequestFilter {
    public void filterRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        String username = wsdlRequest.getUsername();
        if (username == null || username.length() == 0) {
            return;
        }
        HttpClient httpClient = (HttpClient)context.getProperty("httpClient");
        Settings settings = wsdlRequest.getSettings();
        String password = wsdlRequest.getPassword();
        if (settings.getBoolean(HttpSettings.AUTHENTICATE_PREEMPTIVELY)) {
            httpClient.getParams().setAuthenticationPreemptive(true);
            HttpState state = (HttpState)context.getProperty("#HTTP_STATE");
            if (state != null) {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
                state.setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            }
        } else {
            httpClient.getParams().setAuthenticationPreemptive(false);
        }
        TimeablePostMethod postMethod = (TimeablePostMethod)((Object)context.getProperty("postMethod"));
        postMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new WsdlRequestCredentialsProvider(wsdlRequest));
        postMethod.setDoAuthentication(true);
    }
}

