/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.support.ProgressBarAdapter;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;

public class JTestCaseList
extends JPanel {
    private Map<TestCase, TestCaseListPanel> panels = new HashMap<TestCase, TestCaseListPanel>();
    private JPopupMenu popup;
    private final WsdlTestSuite testSuite;
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();

    public JTestCaseList(WsdlTestSuite testSuite) {
        this.testSuite = testSuite;
        this.setLayout(new BoxLayout(this, 1));
        for (int c = 0; c < testSuite.getTestCaseCount(); ++c) {
            TestCaseListPanel testCaseListPanel = new TestCaseListPanel(testSuite.getTestCaseAt(c));
            this.panels.put(testSuite.getTestCaseAt(c), testCaseListPanel);
            this.add(testCaseListPanel);
        }
        this.add(Box.createVerticalGlue());
        this.setBackground(Color.WHITE);
        testSuite.addTestSuiteListener(this.testSuiteListener);
    }

    public void addNotify() {
        super.addNotify();
        this.testSuite.addTestSuiteListener(this.testSuiteListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.testSuite.removeTestSuiteListener(this.testSuiteListener);
    }

    public int[] getSelectedIndices() {
        int cnt = 0;
        for (TestCaseListPanel panel : this.panels.values()) {
            if (!panel.isSelected()) continue;
            ++cnt;
        }
        int[] result = new int[cnt];
        cnt = 0;
        for (int c = 0; c < this.getComponentCount(); ++c) {
            Component comp = this.getComponent(c);
            if (!(comp instanceof TestCaseListPanel) || !((TestCaseListPanel)comp).isSelected()) continue;
            result[cnt] = c;
            ++cnt;
        }
        return result;
    }

    private static final class TestCaseListPanel
    extends JPanel {
        private final TestCase testCase;
        private JProgressBar progressBar;
        private JLabel label;
        private ProgressBarAdapter progressBarAdapter;
        private boolean selected;
        private TestCasePropertyChangeListener testCasePropertyChangeListener;

        public TestCaseListPanel(WsdlTestCase testCase) {
            super(new BorderLayout());
            this.testCase = testCase;
            this.progressBar = new JProgressBar(0, 100);
            JPanel progressPanel = UISupport.createProgressBarPanel(this.progressBar, 5, false);
            this.progressBar.setMinimumSize(new Dimension(0, 10));
            this.progressBar.setBackground(Color.WHITE);
            this.progressBar.setInheritsPopupMenu(true);
            this.progressBarAdapter = new ProgressBarAdapter(this.progressBar, testCase);
            this.label = new JLabel("TestCase: " + testCase.getName());
            this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.label.setInheritsPopupMenu(true);
            this.add((Component)progressPanel, "Center");
            this.add((Component)this.label, "North");
            this.testCasePropertyChangeListener = new TestCasePropertyChangeListener();
            testCase.addPropertyChangeListener(TestCase.NAME_PROPERTY, this.testCasePropertyChangeListener);
            this.setComponentPopupMenu(ActionSupport.buildPopup(testCase.getActions()));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        TestCaseListPanel.this.setSelected(!TestCaseListPanel.this.selected);
                        return;
                    }
                    UISupport.selectAndShow(TestCaseListPanel.this.testCase);
                }
            });
            this.setSelected(false);
        }

        public void removeNotify() {
            super.removeNotify();
            this.testCase.removePropertyChangeListener(this.testCasePropertyChangeListener);
        }

        public Dimension getMaximumSize() {
            Dimension size = super.getMaximumSize();
            size.height = 50;
            return size;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            if (selected) {
                this.setBackground(Color.YELLOW.brighter().brighter());
                this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            } else {
                this.setBackground(Color.WHITE);
                this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        private final class TestCasePropertyChangeListener
        implements PropertyChangeListener {
            private TestCasePropertyChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                TestCaseListPanel.this.label.setText("TestCase: " + TestCaseListPanel.this.testCase.getName());
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testCaseAdded(TestCase testCase) {
            TestCaseListPanel testCaseListPanel = new TestCaseListPanel((WsdlTestCase)testCase);
            JTestCaseList.this.panels.put(testCase, testCaseListPanel);
            JTestCaseList.this.add((Component)testCaseListPanel, JTestCaseList.this.getComponentCount() - 1);
            JTestCaseList.this.revalidate();
            JTestCaseList.this.repaint();
        }

        public void testCaseRemoved(TestCase testCase) {
            TestCaseListPanel testCaseListPanel = (TestCaseListPanel)JTestCaseList.this.panels.get(testCase);
            if (testCaseListPanel != null) {
                JTestCaseList.this.remove(testCaseListPanel);
                JTestCaseList.this.panels.remove(testCase);
                JTestCaseList.this.revalidate();
                JTestCaseList.this.repaint();
            }
        }
    }
}

