/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlPropertiesTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepListenerAdapter;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public class PropertiesStepDesktopPanel
extends JPanel
implements DesktopPanel {
    private final WsdlPropertiesTestStep testStep;
    private JTextField sourceField;
    private JTextField targetField;
    private PropertiesModel propertiesModel;
    private JTable propertiesTable;
    private RemovePropertyAction removePropertyAction;
    private TestRunComponentEnabler componentEnabler;
    private InternalWsdlTestStepListener wsdlTestStepListener;

    public PropertiesStepDesktopPanel(WsdlPropertiesTestStep testStep) {
        super(new BorderLayout());
        this.testStep = testStep;
        this.componentEnabler = new TestRunComponentEnabler(testStep.getTestCase());
        this.buildUI();
        this.wsdlTestStepListener = new InternalWsdlTestStepListener();
        testStep.addTestStepListener(this.wsdlTestStepListener);
    }

    private void buildUI() {
        this.add((Component)this.buildToolbar(), "North");
        this.add(this.buildPropertiesTable(), "Center");
        this.setPreferredSize(new Dimension(600, 400));
    }

    private Component buildPropertiesTable() {
        this.propertiesModel = new PropertiesModel();
        this.propertiesTable = new JTable(this.propertiesModel);
        this.propertiesTable.setDragEnabled(true);
        this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PropertiesStepDesktopPanel.this.removePropertyAction.setEnabled(PropertiesStepDesktopPanel.this.propertiesTable.getSelectedRow() != -1);
            }
        });
        this.componentEnabler.add(this.propertiesTable);
        return new JScrollPane(this.propertiesTable);
    }

    private JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        JButton addPropertyButton = UISupport.createToolbarButton(new AddPropertyAction());
        toolbar.add(addPropertyButton);
        this.removePropertyAction = new RemovePropertyAction();
        JButton removePropertyButton = UISupport.createToolbarButton(this.removePropertyAction);
        toolbar.add(removePropertyButton);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Load from:"));
        this.sourceField = new JTextField(this.testStep.getSource(), 15);
        this.sourceField.setToolTipText("The filename/url or referring system-property to load properties from");
        this.sourceField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                PropertiesStepDesktopPanel.this.testStep.setSource(PropertiesStepDesktopPanel.this.sourceField.getText());
            }
        });
        toolbar.addFixed(this.sourceField);
        JButton setSourceButton = UISupport.createToolbarButton(new SetPropertiesSourceAction());
        toolbar.add(setSourceButton);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Save to:"));
        this.targetField = new JTextField(this.testStep.getTarget(), 15);
        this.targetField.setToolTipText("The filename/url or referring system-property to save properties to");
        this.targetField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                PropertiesStepDesktopPanel.this.testStep.setTarget(PropertiesStepDesktopPanel.this.targetField.getText());
            }
        });
        toolbar.addFixed(this.targetField);
        JButton setTargetButton = UISupport.createToolbarButton(new SetPropertiesTargetAction());
        toolbar.add(setTargetButton);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addSeparator();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertiesstep.html#Properties_Editor")));
        this.componentEnabler.add(this.sourceField);
        this.componentEnabler.add(this.targetField);
        this.componentEnabler.add(setTargetButton);
        this.componentEnabler.add(setSourceButton);
        this.componentEnabler.add(addPropertyButton);
        this.componentEnabler.add(removePropertyButton);
        return toolbar;
    }

    public Icon getIcon() {
        return this.getModelItem().getIcon();
    }

    public ModelItem getModelItem() {
        return this.testStep;
    }

    public boolean onClose(boolean canCancel) {
        if (this.propertiesTable.isEditing()) {
            this.propertiesTable.getCellEditor().stopCellEditing();
        }
        this.componentEnabler.release();
        this.testStep.removeTestStepListener(this.wsdlTestStepListener);
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.testStep || modelItem == this.testStep.getTestCase() || modelItem == this.testStep.getTestCase().getTestSuite() || modelItem == this.testStep.getTestCase().getTestSuite().getProject();
    }

    public String getTitle() {
        return this.testStep.getTestCase().getName() + " - " + this.testStep.getName();
    }

    public String getDescription() {
        return "Properties: [" + this.testStep.getName() + "] - " + this.testStep.getTestStepTitle();
    }

    private class SetPropertiesTargetAction
    extends AbstractAction {
        public SetPropertiesTargetAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/set_properties_target.gif"));
            this.putValue("ShortDescription", "Selects the properties target file");
        }

        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().saveAs(this, "Set properties target");
            if (file != null) {
                PropertiesStepDesktopPanel.this.testStep.setTarget(file.getAbsolutePath());
                PropertiesStepDesktopPanel.this.targetField.setText(PropertiesStepDesktopPanel.this.testStep.getTarget());
                try {
                    int cnt = PropertiesStepDesktopPanel.this.testStep.saveProperties();
                    UISupport.showInfoMessage("Saved " + cnt + " properties to [" + PropertiesStepDesktopPanel.this.testStep.getTarget() + "]");
                }
                catch (IOException e1) {
                    UISupport.showErrorMessage("Failed to save properties to [" + PropertiesStepDesktopPanel.this.testStep.getTarget() + "]; " + e1);
                }
            }
        }
    }

    private class SetPropertiesSourceAction
    extends AbstractAction {
        public SetPropertiesSourceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/set_properties_source.gif"));
            this.putValue("ShortDescription", "Selects the properties source file");
        }

        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().open(this, "Set properties source", null, null);
            if (file != null) {
                PropertiesStepDesktopPanel.this.testStep.setSource(file.getAbsolutePath());
                PropertiesStepDesktopPanel.this.sourceField.setText(PropertiesStepDesktopPanel.this.testStep.getSource());
                try {
                    boolean createMissing = UISupport.confirm("Create missing properties", "Set Properties Source");
                    int cnt = PropertiesStepDesktopPanel.this.testStep.loadProperties(createMissing);
                    UISupport.showInfoMessage("Loaded " + cnt + " properties from [" + PropertiesStepDesktopPanel.this.testStep.getSource() + "]");
                }
                catch (IOException e1) {
                    UISupport.showErrorMessage("Failed to load properties from [" + PropertiesStepDesktopPanel.this.testStep.getSource() + "]; " + e1);
                }
            }
        }
    }

    private class RemovePropertyAction
    extends AbstractAction {
        public RemovePropertyAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected property from the property list");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = PropertiesStepDesktopPanel.this.propertiesTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            UISupport.stopCellEditing(PropertiesStepDesktopPanel.this.propertiesTable);
            if (UISupport.confirm("Remove property [" + PropertiesStepDesktopPanel.this.propertiesModel.getValueAt(row, 0) + "]?", "Remove Property")) {
                PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(false);
                PropertiesStepDesktopPanel.this.testStep.removePropertyAt(row);
                PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(true);
                PropertiesStepDesktopPanel.this.propertiesModel.fireTableRowsDeleted(row, row);
            }
        }
    }

    private class AddPropertyAction
    extends AbstractAction {
        public AddPropertyAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a property to the property list");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify property name", "Add Property", "");
            if (name != null) {
                PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(false);
                PropertiesStepDesktopPanel.this.testStep.addProperty(name);
                PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(true);
                int row = PropertiesStepDesktopPanel.this.testStep.getStepPropertyCount() - 1;
                PropertiesStepDesktopPanel.this.propertiesModel.fireTableRowsInserted(row, row);
                PropertiesStepDesktopPanel.this.propertiesTable.editCellAt(row, 1);
            }
        }
    }

    private class PropertiesModel
    extends AbstractTableModel {
        private PropertiesModel() {
        }

        public int getRowCount() {
            return PropertiesStepDesktopPanel.this.testStep.getStepPropertyCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            WsdlPropertiesTestStep.StepProperty property = PropertiesStepDesktopPanel.this.testStep.getTestStepPropertyAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    TestStepProperty prop = PropertiesStepDesktopPanel.this.testStep.getProperty((String)aValue);
                    if (prop != null && prop != property) {
                        UISupport.showErrorMessage("Property name exists!");
                        return;
                    }
                    PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(false);
                    property.setName(aValue.toString());
                    PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(true);
                    break;
                }
                case 1: {
                    PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(false);
                    property.setValue(aValue.toString());
                    PropertiesStepDesktopPanel.this.wsdlTestStepListener.setEnabled(true);
                }
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            WsdlPropertiesTestStep.StepProperty property = PropertiesStepDesktopPanel.this.testStep.getTestStepPropertyAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return property.getName();
                }
                case 1: {
                    return property.getValue();
                }
            }
            return null;
        }
    }

    private final class InternalWsdlTestStepListener
    extends WsdlTestStepListenerAdapter {
        private boolean enabled = true;

        private InternalWsdlTestStepListener() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void propertyAdded(String name) {
            if (this.enabled) {
                PropertiesStepDesktopPanel.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyRemoved(String name) {
            if (this.enabled) {
                PropertiesStepDesktopPanel.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyRenamed(String oldName, String newName) {
            if (this.enabled) {
                PropertiesStepDesktopPanel.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
            if (this.enabled) {
                PropertiesStepDesktopPanel.this.propertiesModel.fireTableDataChanged();
            }
        }
    }
}

