/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockTestRunner
implements TestRunner {
    private long startTime;
    private String reason;
    private final WsdlTestCase testCase;
    private final Logger logger;

    public MockTestRunner(WsdlTestCase testCase) {
        this(testCase, null);
    }

    public MockTestRunner(WsdlTestCase testCase, Logger logger) {
        this.testCase = testCase;
        this.logger = logger == null ? SoapUI.ensureGroovyLog() : logger;
        this.startTime = System.currentTimeMillis();
    }

    public Logger getLog() {
        return this.logger;
    }

    @Override
    public TestCase getTestCase() {
        return this.testCase;
    }

    @Override
    public List<TestStepResult> getResults() {
        return new ArrayList<TestStepResult>();
    }

    @Override
    public TestRunner.Status getStatus() {
        return TestRunner.Status.RUNNING;
    }

    @Override
    public void start(boolean async) {
    }

    @Override
    public long getTimeTaken() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public TestRunner.Status waitUntilFinished() {
        return TestRunner.Status.FINISHED;
    }

    @Override
    public void cancel(String reason) {
        this.reason = reason;
        this.logger.info((Object)("Canceled with reason [" + reason + "]"));
    }

    @Override
    public void gotoStep(int index) {
        this.logger.info((Object)("Going to step " + index + " [" + this.testCase.getTestStepAt(index).getName() + "]"));
    }

    @Override
    public void gotoStepByName(String stepName) {
        this.logger.info((Object)("Going to step [" + stepName + "]"));
    }

    @Override
    public void fail(String reason) {
        this.reason = reason;
        this.logger.error((Object)("Failed with reason [" + reason + "]"));
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getReason() {
        return this.reason;
    }
}

