/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.source;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.actions.request.AddWSSUsernameTokenAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddWSTimestampAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResultMessageExchange;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditorView;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.support.ValidationError;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.registry.RequestEditorViewFactory;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.registry.ResponseEditorViewFactory;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.source.XmlSourceEditorView;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlValidator;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.xml.JXEditTextArea;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class XmlSourceEditorFactory
implements ResponseEditorViewFactory,
RequestEditorViewFactory {
    public static final String VIEW_ID = "Source";

    public XmlEditorView createEditorView(XmlEditor editor) {
        return new XmlSourceEditorView(editor);
    }

    public String getViewId() {
        return VIEW_ID;
    }

    public XmlEditorView createRequestEditorView(XmlEditor editor, ModelItem modelItem) {
        if (modelItem instanceof WsdlRequest) {
            return new WsdlRequestXmlSourceEditor(editor, (WsdlRequest)modelItem);
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockRequestXmlSourceEditor(editor, (WsdlMockResponse)modelItem);
        }
        return null;
    }

    public XmlEditorView createResponseEditorView(XmlEditor editor, ModelItem modelItem) {
        if (modelItem instanceof WsdlRequest) {
            return new WsdlResponseXmlSourceEditor(editor, (WsdlRequest)modelItem);
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockResponseXmlSourceEditor(editor, (WsdlMockResponse)modelItem);
        }
        return null;
    }

    public static class WsdlMockResponseXmlSourceEditor
    extends XmlSourceEditorView {
        private final WsdlMockResponse mockResponse;

        public WsdlMockResponseXmlSourceEditor(XmlEditor xmlEditor, WsdlMockResponse mockResponse) {
            super(xmlEditor);
            this.mockResponse = mockResponse;
        }

        protected ValidationError[] validateXml(String xml) {
            WsdlOperation operation = this.mockResponse.getMockOperation().getOperation();
            if (operation == null) {
                return new ValidationError[]{new AssertionError("Missing operation for MockResponse")};
            }
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            return validator.assertResponse(new WsdlMockResponseMessageExchange(this.mockResponse), false);
        }
    }

    public static class WsdlResponseXmlSourceEditor
    extends XmlSourceEditorView {
        private final WsdlRequest request;

        public WsdlResponseXmlSourceEditor(XmlEditor xmlEditor, WsdlRequest request) {
            super(xmlEditor);
            this.request = request;
        }

        protected ValidationError[] validateXml(String xml) {
            if (this.request instanceof WsdlTestRequest) {
                WsdlTestRequest testRequest = (WsdlTestRequest)this.request;
                testRequest.assertResponse(new WsdlSubmitContext(testRequest.getTestStep()));
            }
            WsdlOperation operation = this.request.getOperation();
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            return validator.assertResponse(new WsdlResponseMessageExchange(this.request), false);
        }
    }

    public static class WsdlMockRequestXmlSourceEditor
    extends XmlSourceEditorView {
        private final WsdlMockResponse mockResponse;

        public WsdlMockRequestXmlSourceEditor(XmlEditor xmlEditor, WsdlMockResponse mockResponse) {
            super(xmlEditor);
            this.mockResponse = mockResponse;
        }

        protected ValidationError[] validateXml(String xml) {
            WsdlOperation operation = this.mockResponse.getMockOperation().getOperation();
            if (operation == null) {
                return new ValidationError[]{new AssertionError("Missing operation for MockResponse")};
            }
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            return validator.assertRequest(new WsdlMockResultMessageExchange(this.mockResponse.getMockResult()), false);
        }

        protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
            super.buildPopup(inputPopup, editArea);
            inputPopup.insert(new JSeparator(), 2);
        }
    }

    public static class WsdlRequestXmlSourceEditor
    extends XmlSourceEditorView {
        private final WsdlRequest request;

        public WsdlRequestXmlSourceEditor(XmlEditor xmlEditor, WsdlRequest request) {
            super(xmlEditor);
            this.request = request;
        }

        protected ValidationError[] validateXml(String xml) {
            WsdlOperation operation = this.request.getOperation();
            WsdlValidator validator = new WsdlValidator(operation.getInterface().getWsdlContext());
            WsdlResponseMessageExchange wsdlResponseMessageExchange = new WsdlResponseMessageExchange(this.request);
            wsdlResponseMessageExchange.setRequestContent(xml);
            return validator.assertRequest(wsdlResponseMessageExchange, false);
        }

        protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
            super.buildPopup(inputPopup, editArea);
            inputPopup.insert(new JSeparator(), 2);
            inputPopup.insert(new AddWSSUsernameTokenAction(this.request), 3);
            inputPopup.insert(new AddWSTimestampAction(this.request), 4);
        }
    }
}

