/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.actions.operation.AddToMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.request.CloneRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.CreateEmptyRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RecreateRequestAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.attachments.AttachmentPanel;
import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.impl.wsdl.panels.request.actions.WSIValidateRequestAction;
import com.eviware.soapui.impl.wsdl.panels.request.components.RequestMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.RequestXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.request.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.ResponseXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.request.components.SoapMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlDocument;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.source.XmlSourceEditorView;
import com.eviware.soapui.impl.wsdl.panels.support.EndpointsComboBoxModel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.cert.Certificate;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractWsdlRequestDesktopPanel<T extends ModelItem, T2 extends WsdlRequest>
extends ModelItemDesktopPanel<T> {
    private static final Logger log = Logger.getLogger(AbstractWsdlRequestDesktopPanel.class);
    private JComboBox endpointCombo;
    private JButton submitButton;
    private JButton cancelButton;
    private EndpointsComboBoxModel endpointsModel;
    private JEditorStatusBarWithProgress statusBar;
    private JButton splitButton;
    private Submit submit;
    private JButton recreateButton;
    private JButton cloneButton;
    private JButton createEmptyButton;
    private InternalSubmitListener internalSubmitListener;
    private JSplitPane requestSplitPane;
    private MoveFocusAction moveFocusAction;
    private ClosePanelAction closePanelAction = new ClosePanelAction();
    private T2 request;
    private SoapMessageXmlEditor requestEditor;
    private SoapMessageXmlEditor responseEditor;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private JToggleButton tabsButton;
    public boolean responseHasFocus;
    private JTabbedPane requestEditorTabs;
    private JTabbedPane responseEditorTabs;
    private JPanel requestEditorTabPanel;
    private JPanel responseEditorTabPanel;
    private AttachmentPropertyChangeListener attachmentsPropertyChangeListener = new AttachmentPropertyChangeListener();
    private StringToStringMapTableModel requestHeadersModel;
    private JTable requestHeadersTable;
    private StringToStringMapTableModel responseHeadersModel;
    private JEditorPane sslInfoPane;
    private JButton addToMockServiceButton;
    private WSIValidateRequestAction wsiValidateAction;

    public AbstractWsdlRequestDesktopPanel(T modelItem) {
        super(modelItem);
    }

    protected void init(T2 request) {
        this.request = request;
        this.endpointsModel = new EndpointsComboBoxModel((WsdlRequest)request);
        this.internalSubmitListener = this.createSubmitListener();
        ((WsdlRequest)request).addSubmitListener(this.internalSubmitListener);
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        ((AbstractModelItem)request).addPropertyChangeListener(this.attachmentsPropertyChangeListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AbstractWsdlRequestDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AbstractWsdlRequestDesktopPanel.this.responseHasFocus) {
                    AbstractWsdlRequestDesktopPanel.this.responseEditor.requestFocusInWindow();
                } else {
                    AbstractWsdlRequestDesktopPanel.this.requestEditor.requestFocusInWindow();
                }
            }
        });
    }

    protected InternalSubmitListener createSubmitListener() {
        return new InternalSubmitListener();
    }

    public final T2 getRequest() {
        return this.request;
    }

    public final SoapMessageXmlEditor getRequestEditor() {
        return this.requestEditor;
    }

    public final SoapMessageXmlEditor getResponseEditor() {
        return this.responseEditor;
    }

    public Submit getSubmit() {
        return this.submit;
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    public JEditorStatusBarWithProgress getStatusBar() {
        return this.statusBar;
    }

    protected JComponent buildContent() {
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.submitButton = this.createActionButton(new SubmitAction(), true);
        this.cancelButton = this.createActionButton(new CancelAction(), false);
        this.splitButton = this.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.recreateButton = this.createActionButton(new RecreateRequestAction((WsdlRequest)this.request), true);
        this.addToMockServiceButton = this.createActionButton(new AddToMockServiceAction((WsdlRequest)this.request), true);
        this.cloneButton = this.createActionButton(new CloneRequestAction((WsdlRequest)this.request), true);
        this.createEmptyButton = this.createActionButton(new CreateEmptyRequestAction((WsdlRequest)this.request), true);
        this.submitButton.setEnabled(((WsdlRequest)this.request).getEndpoint() != null && ((WsdlRequest)this.request).getEndpoint().trim().length() > 0);
        this.wsiValidateAction = new WSIValidateRequestAction((WsdlRequest)this.request);
        this.moveFocusAction = new MoveFocusAction();
        this.requestEditor = this.buildRequestEditor();
        this.responseEditor = this.buildResponseEditor();
        this.requestEditorTabs = new JTabbedPane(3);
        this.requestEditorTabs.setTabLayoutPolicy(1);
        this.requestEditorTabs.addTab("SOAP Request", this.requestEditor);
        this.requestEditorTabs.addTab("Request Attachments (" + ((WsdlRequest)this.request).getAttachmentCount() + ")", new AttachmentPanel((WsdlRequest)this.request, true));
        this.requestEditorTabs.addTab("HTTP Headers (" + ((WsdlRequest)this.request).getRequestHeaders().size() + ")", this.createRequestHttpHeadersPanel());
        this.requestEditorTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ix = AbstractWsdlRequestDesktopPanel.this.requestEditorTabs.getSelectedIndex();
                        if (ix == 0) {
                            AbstractWsdlRequestDesktopPanel.this.requestEditor.requestFocus();
                        }
                    }
                });
            }
        });
        this.responseEditorTabs = new JTabbedPane(3);
        this.responseEditorTabs.setTabLayoutPolicy(1);
        this.responseEditorTabs.addTab("SOAP Response", this.responseEditor);
        this.responseEditorTabs.addTab("Response Attachments (" + (((WsdlRequest)this.request).getResponse() == null ? 0 : ((WsdlRequest)this.request).getResponse().getAttachments().length) + ")", new AttachmentPanel((WsdlRequest)this.request, false));
        this.responseEditorTabs.addTab("HTTP Headers", this.createResponseHttpHeadersPanel());
        String sslInfoTabTitle = "SSL Info";
        sslInfoTabTitle = ((WsdlRequest)this.request).getResponse() != null && ((WsdlRequest)this.request).getResponse().getSSLInfo() != null ? sslInfoTabTitle + " (" + ((WsdlRequest)this.request).getResponse().getSSLInfo().getPeerCertificates().length + " certs)" : sslInfoTabTitle + " (-)";
        this.responseEditorTabs.addTab(sslInfoTabTitle, this.createSSLInfoPanel());
        this.responseEditorTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ix = AbstractWsdlRequestDesktopPanel.this.responseEditorTabs.getSelectedIndex();
                        if (ix == 0) {
                            AbstractWsdlRequestDesktopPanel.this.responseEditor.requestFocus();
                        }
                    }
                });
            }
        });
        this.requestTabs = new JTabbedPane();
        this.requestTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ix = AbstractWsdlRequestDesktopPanel.this.requestTabs.getSelectedIndex();
                        if (ix == 0 && AbstractWsdlRequestDesktopPanel.this.requestEditorTabs.getSelectedIndex() == 0) {
                            AbstractWsdlRequestDesktopPanel.this.requestEditor.requestFocus();
                        } else if (ix == 1 && AbstractWsdlRequestDesktopPanel.this.responseEditorTabs.getSelectedIndex() == 0) {
                            AbstractWsdlRequestDesktopPanel.this.responseEditor.requestFocus();
                        }
                    }
                });
            }
        });
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        this.requestEditorTabPanel = UISupport.createTabPanel(this.requestEditorTabs, false);
        this.responseEditorTabPanel = UISupport.createTabPanel(this.responseEditorTabs, false);
        if (((AbstractWsdlModelItem)this.request).getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Request", this.requestEditorTabPanel);
            this.requestTabs.addTab("Response", this.responseEditorTabPanel);
            this.splitButton.setEnabled(false);
            this.tabsButton.setSelected(true);
            return this.requestTabPanel;
        }
        this.requestSplitPane.setTopComponent(this.requestEditorTabPanel);
        this.requestSplitPane.setBottomComponent(this.responseEditorTabPanel);
        this.requestSplitPane.setDividerLocation(0.5);
        return this.requestSplitPane;
    }

    private Component createSSLInfoPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.sslInfoPane = new JEditorPane();
        this.sslInfoPane.setEditorKit(new HTMLEditorKit());
        panel.add(new JScrollPane(this.sslInfoPane));
        return panel;
    }

    private void updateSSLInfo(SSLInfo sslInfo) {
        String sslInfoTabTitle = "SSL Info";
        if (sslInfo == null) {
            this.sslInfoPane.setText("<html><body>Not an SSL connection</body></html>");
            sslInfoTabTitle = sslInfoTabTitle + " (-)";
        } else {
            Certificate[] peerCertificates;
            Certificate[] localCertificates;
            StringBuffer buf = new StringBuffer("<html><body><table cellpadding=1 cellspacing=1 border=0>");
            buf.append("<tr><td><b>CipherSuite:</b></td><td align=left valign=top>").append(sslInfo.getCipherSuite().toString()).append("</td></tr>");
            if (sslInfo.getLocalPrincipal() != null) {
                buf.append("<tr><td><b>LocalPrincipal:</b></td><td align=left valign=top>").append(sslInfo.getLocalPrincipal().getName()).append("</td></tr>");
            }
            if ((localCertificates = sslInfo.getLocalCertificates()) != null) {
                buf.append("</table><table cellpadding=0 cellspacing=0 border=0>");
                int cnt = 1;
                for (Certificate cert : localCertificates) {
                    buf.append("<tr><td><b>Local Certificate ").append(cnt++).append(":</b><pre><font size=-1>").append(cert.toString()).append("</font></pre></td></tr>");
                }
                buf.append("</table><table cellpadding=1 cellspacing=1 border=0>");
            }
            if (sslInfo.getPeerPrincipal() != null) {
                buf.append("<tr><td><b>PeerPrincipal:</b></td><td align=left valign=top>").append(((Object)sslInfo.getPeerPrincipal()).toString()).append("</td></tr>");
            }
            if ((peerCertificates = sslInfo.getPeerCertificates()) != null) {
                buf.append("</table><table cellpadding=0 cellspacing=0 border=0>");
                int cnt = 1;
                for (Certificate cert : peerCertificates) {
                    buf.append("<tr><td colspan=2><b>Peer Certificate ").append(cnt++).append(":</b><pre><font size=-1>").append(cert.toString()).append("</font></pre></td></tr>");
                }
                buf.append("</table><table cellpadding=0 cellspacing=0 border=0>");
            }
            buf.append("</table></body></html>");
            this.sslInfoPane.setText(buf.toString());
            sslInfoTabTitle = sslInfoTabTitle + " (" + sslInfo.getPeerCertificates().length + " certs)";
        }
        this.responseEditorTabs.setTitleAt(3, sslInfoTabTitle);
    }

    private Component createResponseHttpHeadersPanel() {
        this.responseHeadersModel = new StringToStringMapTableModel(((WsdlRequest)this.request).getResponse() == null ? new StringToStringMap() : ((WsdlRequest)this.request).getResponse().getResponseHeaders(), "Header", "Value", false);
        this.responseHeadersModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                AbstractWsdlRequestDesktopPanel.this.responseEditorTabs.setTitleAt(2, "HTTP Headers (" + AbstractWsdlRequestDesktopPanel.this.responseHeadersModel.getRowCount() + ")");
            }
        });
        JTable responseHeadersTable = new JTable(this.responseHeadersModel);
        return new JScrollPane(responseHeadersTable);
    }

    private Component createRequestHttpHeadersPanel() {
        this.requestHeadersModel = new StringToStringMapTableModel(((WsdlRequest)this.request).getRequestHeaders(), "Header", "Value", true);
        this.requestHeadersModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                ((WsdlRequest)AbstractWsdlRequestDesktopPanel.this.getRequest()).setRequestHeaders(AbstractWsdlRequestDesktopPanel.this.requestHeadersModel.getData());
                AbstractWsdlRequestDesktopPanel.this.requestEditorTabs.setTitleAt(2, "HTTP Headers (" + AbstractWsdlRequestDesktopPanel.this.requestHeadersModel.getRowCount() + ")");
            }
        });
        this.requestHeadersTable = new JTable(this.requestHeadersModel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.requestHeadersTable), "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JButton(new AbstractAction("Add"){

            public void actionPerformed(ActionEvent arg0) {
                String header = UISupport.prompt("Specify name of header to add", "Add HTTP Header", "");
                if (header != null) {
                    AbstractWsdlRequestDesktopPanel.this.requestHeadersModel.add(header.toString(), "");
                }
            }
        }));
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent arg0) {
                int row = AbstractWsdlRequestDesktopPanel.this.requestHeadersTable.getSelectedRow();
                if (row != -1 && UISupport.confirm("Delete selected header?", "Remove Header")) {
                    AbstractWsdlRequestDesktopPanel.this.requestHeadersModel.remove(row);
                }
            }
        }));
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add((Component)builder.getPanel(), "South");
        return panel;
    }

    protected SoapMessageXmlEditor buildResponseEditor() {
        return new WsdlResponseMessageEditor(new ResponseXmlDocument((WsdlRequest)this.request));
    }

    protected SoapMessageXmlEditor buildRequestEditor() {
        return new WsdlRequestMessageEditor(new RequestXmlDocument((WsdlRequest)this.request));
    }

    protected JComponent buildToolbar() {
        this.endpointCombo = new JComboBox(this.endpointsModel);
        this.endpointCombo.setToolTipText(this.endpointsModel.getSelectedItem().toString());
        this.endpointCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object item = AbstractWsdlRequestDesktopPanel.this.endpointCombo.getSelectedItem();
                if (item == null) {
                    AbstractWsdlRequestDesktopPanel.this.endpointCombo.setToolTipText("- no endpoint set for request -");
                } else {
                    String selectedItem = item.toString();
                    AbstractWsdlRequestDesktopPanel.this.endpointCombo.setToolTipText(selectedItem);
                }
                AbstractWsdlRequestDesktopPanel.this.submitButton.setEnabled(AbstractWsdlRequestDesktopPanel.this.submit == null && AbstractWsdlRequestDesktopPanel.this.request.getEndpoint() != null && AbstractWsdlRequestDesktopPanel.this.request.getEndpoint().trim().length() > 0);
            }
        });
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(this.submitButton);
        this.insertButtons(toolbar);
        toolbar.add(this.addToMockServiceButton);
        toolbar.add(this.recreateButton);
        toolbar.add(this.createEmptyButton);
        toolbar.add(this.cloneButton);
        toolbar.add(this.cancelButton);
        toolbar.addSeparator();
        toolbar.add(this.endpointCombo);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.tabsButton);
        toolbar.add(this.splitButton);
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(this.getHelpUrl())));
        return toolbar;
    }

    protected String getHelpUrl() {
        return "http://www.soapui.org/userguide/requests.html#The_Request_Editor";
    }

    protected void insertButtons(JToolBar toolbar) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.endpointCombo.setEnabled(enabled);
        this.requestEditor.setEditable(enabled);
        this.responseEditor.setEditable(enabled);
        this.submitButton.setEnabled(enabled && ((WsdlRequest)this.request).getEndpoint() != null && ((WsdlRequest)this.request).getEndpoint().trim().length() > 0);
        this.recreateButton.setEnabled(enabled);
        this.createEmptyButton.setEnabled(enabled);
        this.cloneButton.setEnabled(enabled);
        this.statusBar.setIndeterminate(!enabled);
    }

    protected Submit doSubmit() throws Request.SubmitException {
        return ((WsdlRequest)this.request).submit(new WsdlSubmitContext(null), true);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (canCancel) {
            if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
                Boolean retVal = UISupport.confirmOrCancel("Cancel request before closing?", "Closing window");
                if (retVal == null) {
                    return false;
                }
                if (retVal.booleanValue() && this.submit.getStatus() == Submit.Status.RUNNING) {
                    this.submit.cancel();
                }
            }
        } else if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
            this.submit.cancel();
        }
        ((WsdlRequest)this.request).removeSubmitListener(this.internalSubmitListener);
        ((AbstractModelItem)this.request).removePropertyChangeListener(this.attachmentsPropertyChangeListener);
        this.endpointsModel.release();
        this.requestEditor.saveDocument(false);
        return true;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.request || modelItem == ((WsdlRequest)this.request).getOperation() || modelItem == ((WsdlRequest)this.request).getOperation().getInterface() || modelItem == ((WsdlRequest)this.request).getOperation().getInterface().getProject();
    }

    @Override
    public String getDescription() {
        return "Request: [" + ((AbstractWsdlModelItem)this.request).getName() + "] - " + ((WsdlRequest)this.request).getOperation().getInterface().getName() + "#" + ((WsdlRequest)this.request).getOperation().getName();
    }

    public void setContent(JComponent content) {
        this.add((Component)content, "Center");
    }

    public void removeContent(JComponent content) {
        this.remove(content);
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlRequestDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlRequestDesktopPanel.this.splitButton.setEnabled(false);
                AbstractWsdlRequestDesktopPanel.this.removeContent(AbstractWsdlRequestDesktopPanel.this.requestSplitPane);
                AbstractWsdlRequestDesktopPanel.this.setContent(AbstractWsdlRequestDesktopPanel.this.requestTabPanel);
                AbstractWsdlRequestDesktopPanel.this.requestTabs.addTab("Request", AbstractWsdlRequestDesktopPanel.this.requestEditorTabPanel);
                AbstractWsdlRequestDesktopPanel.this.requestTabs.addTab("Response", AbstractWsdlRequestDesktopPanel.this.responseEditorTabPanel);
                if (AbstractWsdlRequestDesktopPanel.this.responseHasFocus) {
                    AbstractWsdlRequestDesktopPanel.this.requestTabs.setSelectedIndex(1);
                    AbstractWsdlRequestDesktopPanel.this.requestEditorTabs.requestFocus();
                } else {
                    AbstractWsdlRequestDesktopPanel.this.responseEditorTabs.requestFocus();
                }
            } else {
                int selectedIndex = AbstractWsdlRequestDesktopPanel.this.requestTabs.getSelectedIndex();
                AbstractWsdlRequestDesktopPanel.this.splitButton.setEnabled(true);
                AbstractWsdlRequestDesktopPanel.this.removeContent(AbstractWsdlRequestDesktopPanel.this.requestTabPanel);
                AbstractWsdlRequestDesktopPanel.this.setContent(AbstractWsdlRequestDesktopPanel.this.requestSplitPane);
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setTopComponent(AbstractWsdlRequestDesktopPanel.this.requestEditorTabPanel);
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setBottomComponent(AbstractWsdlRequestDesktopPanel.this.responseEditorTabPanel);
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0) {
                    AbstractWsdlRequestDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    AbstractWsdlRequestDesktopPanel.this.responseEditor.requestFocus();
                }
            }
            AbstractWsdlRequestDesktopPanel.this.revalidate();
        }
    }

    protected class InternalSubmitListener
    implements SubmitListener {
        protected InternalSubmitListener() {
        }

        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() != AbstractWsdlRequestDesktopPanel.this.request) {
                return true;
            }
            if (AbstractWsdlRequestDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.AUTO_VALIDATE_REQUEST)) {
                boolean result = AbstractWsdlRequestDesktopPanel.this.requestEditor.saveDocument(true);
                if (!result && AbstractWsdlRequestDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.ABORT_ON_INVALID_REQUEST)) {
                    AbstractWsdlRequestDesktopPanel.this.statusBar.setInfo("Cancelled request due to invalid content");
                    return false;
                }
            } else {
                AbstractWsdlRequestDesktopPanel.this.requestEditor.saveDocument(false);
            }
            AbstractWsdlRequestDesktopPanel.this.setEnabled(false);
            AbstractWsdlRequestDesktopPanel.this.cancelButton.setEnabled(AbstractWsdlRequestDesktopPanel.this.submit != null);
            AbstractWsdlRequestDesktopPanel.this.wsiValidateAction.setEnabled(false);
            return true;
        }

        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() != AbstractWsdlRequestDesktopPanel.this.request) {
                return;
            }
            Submit.Status status = submit.getStatus();
            WsdlResponse response = (WsdlResponse)submit.getResponse();
            if (status != Submit.Status.CANCELED) {
                AbstractWsdlRequestDesktopPanel.this.request.setResponse(response, context);
            }
            AbstractWsdlRequestDesktopPanel.this.cancelButton.setEnabled(false);
            AbstractWsdlRequestDesktopPanel.this.setEnabled(true);
            String message = null;
            String infoMessage = null;
            String requestName = AbstractWsdlRequestDesktopPanel.this.request.getOperation().getInterface().getName() + "." + AbstractWsdlRequestDesktopPanel.this.request.getOperation().getName() + ":" + AbstractWsdlRequestDesktopPanel.this.request.getName();
            if (status == Submit.Status.CANCELED) {
                message = "CANCELED";
                infoMessage = "[" + requestName + "] - CANCELED";
            } else {
                if (status == Submit.Status.ERROR || response == null) {
                    message = "Error getting response; " + submit.getError();
                    infoMessage = "Error getting response for [" + requestName + "]; " + submit.getError();
                } else {
                    message = "response time: " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
                    infoMessage = "Got response for [" + requestName + "] in " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
                    if (!AbstractWsdlRequestDesktopPanel.this.splitButton.isEnabled()) {
                        AbstractWsdlRequestDesktopPanel.this.requestTabs.setSelectedIndex(1);
                    }
                    AbstractWsdlRequestDesktopPanel.this.responseEditor.requestFocus();
                }
                AbstractWsdlRequestDesktopPanel.this.responseHeadersModel.setData(submit.getResponse() == null ? null : submit.getResponse().getResponseHeaders());
                AbstractWsdlRequestDesktopPanel.this.updateSSLInfo(response == null ? null : response.getSSLInfo());
                AbstractWsdlRequestDesktopPanel.this.wsiValidateAction.setEnabled(true);
            }
            this.logMessages(message, infoMessage);
            if (AbstractWsdlRequestDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.AUTO_VALIDATE_RESPONSE)) {
                AbstractWsdlRequestDesktopPanel.this.responseEditor.getSourceEditor().validate();
            }
            AbstractWsdlRequestDesktopPanel.this.submit = null;
        }

        protected void logMessages(String message, String infoMessage) {
            log.info((Object)infoMessage);
            AbstractWsdlRequestDesktopPanel.this.statusBar.setInfo(message);
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private MoveFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlRequestDesktopPanel.this.requestEditor.hasFocus()) {
                AbstractWsdlRequestDesktopPanel.this.responseEditor.requestFocus();
            } else {
                AbstractWsdlRequestDesktopPanel.this.requestEditor.requestFocus();
            }
        }
    }

    private class ClosePanelAction
    extends AbstractAction {
        private ClosePanelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel((ModelItem)AbstractWsdlRequestDesktopPanel.this.getModelItem());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/cancel_request.gif"));
            this.putValue("ShortDescription", "Aborts ongoing request");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt X"));
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlRequestDesktopPanel.this.submit == null) {
                return;
            }
            AbstractWsdlRequestDesktopPanel.this.cancelButton.setEnabled(false);
            AbstractWsdlRequestDesktopPanel.this.submit.cancel();
            this.setEnabled(true);
            AbstractWsdlRequestDesktopPanel.this.submit = null;
        }
    }

    public class SubmitAction
    extends AbstractAction {
        public SubmitAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Submit request to specified endpoint URL");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlRequestDesktopPanel.this.submit != null && AbstractWsdlRequestDesktopPanel.this.submit.getStatus() == Submit.Status.RUNNING) {
                if (UISupport.confirm("Cancel current request?", "Submit Request")) {
                    AbstractWsdlRequestDesktopPanel.this.submit.cancel();
                } else {
                    return;
                }
            }
            try {
                AbstractWsdlRequestDesktopPanel.this.submit = AbstractWsdlRequestDesktopPanel.this.doSubmit();
            }
            catch (Request.SubmitException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected final class ResultAreaFocusListener
    implements FocusListener {
        protected ResultAreaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            int maximumDividerLocation;
            AbstractWsdlRequestDesktopPanel.this.responseHasFocus = true;
            AbstractWsdlRequestDesktopPanel.this.statusBar.setTarget(AbstractWsdlRequestDesktopPanel.this.responseEditor.getSourceEditor().getInputArea());
            if (!AbstractWsdlRequestDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlRequestDesktopPanel.this.requestTabs.setSelectedIndex(1);
                return;
            }
            if (AbstractWsdlRequestDesktopPanel.this.request.getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractWsdlRequestDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged() || AbstractWsdlRequestDesktopPanel.this.request.getResponse() == null) {
                return;
            }
            int pos = AbstractWsdlRequestDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos + 600 < (maximumDividerLocation = AbstractWsdlRequestDesktopPanel.this.requestSplitPane.getMaximumDividerLocation())) {
                return;
            }
            if (maximumDividerLocation > 700) {
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setDividerLocation(maximumDividerLocation - 600);
            } else {
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setDividerLocation(0.2);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    protected final class InputAreaFocusListener
    implements FocusListener {
        protected InputAreaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            AbstractWsdlRequestDesktopPanel.this.responseHasFocus = false;
            AbstractWsdlRequestDesktopPanel.this.statusBar.setTarget(AbstractWsdlRequestDesktopPanel.this.requestEditor.getSourceEditor().getInputArea());
            if (!AbstractWsdlRequestDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlRequestDesktopPanel.this.requestTabs.setSelectedIndex(0);
                return;
            }
            if (AbstractWsdlRequestDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractWsdlRequestDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractWsdlRequestDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos >= 600) {
                return;
            }
            if (AbstractWsdlRequestDesktopPanel.this.requestSplitPane.getMaximumDividerLocation() > 700) {
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setDividerLocation(600);
            } else {
                AbstractWsdlRequestDesktopPanel.this.requestSplitPane.setDividerLocation(0.8);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WsdlResponseMessageEditor
    extends ResponseMessageXmlEditor<WsdlRequest> {
        public WsdlResponseMessageEditor(XmlDocument document) {
            super(document, AbstractWsdlRequestDesktopPanel.this.request);
            XmlSourceEditorView editor = this.getSourceEditor();
            JXEditTextArea inputArea = editor.getInputArea();
            inputArea.addFocusListener(new ResultAreaFocusListener());
            inputArea.getInputHandler().addKeyBinding("A+ENTER", AbstractWsdlRequestDesktopPanel.this.submitButton.getAction());
            inputArea.getInputHandler().addKeyBinding("A+X", AbstractWsdlRequestDesktopPanel.this.cancelButton.getAction());
            inputArea.getInputHandler().addKeyBinding("AC+TAB", AbstractWsdlRequestDesktopPanel.this.moveFocusAction);
            inputArea.getInputHandler().addKeyBinding("C+F4", AbstractWsdlRequestDesktopPanel.this.closePanelAction);
            JPopupMenu inputPopup = editor.getEditorPopup();
            inputPopup.insert(new JSeparator(), 2);
            inputPopup.insert(AbstractWsdlRequestDesktopPanel.this.wsiValidateAction, 3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WsdlRequestMessageEditor
    extends RequestMessageXmlEditor<WsdlRequest> {
        public WsdlRequestMessageEditor(XmlDocument document) {
            super(document, AbstractWsdlRequestDesktopPanel.this.request);
            XmlSourceEditorView editor = this.getSourceEditor();
            JXEditTextArea inputArea = editor.getInputArea();
            inputArea.getInputHandler().addKeyBinding("A+ENTER", AbstractWsdlRequestDesktopPanel.this.submitButton.getAction());
            inputArea.getInputHandler().addKeyBinding("A+X", AbstractWsdlRequestDesktopPanel.this.cancelButton.getAction());
            inputArea.getInputHandler().addKeyBinding("AC+TAB", AbstractWsdlRequestDesktopPanel.this.moveFocusAction);
            inputArea.getInputHandler().addKeyBinding("F5", AbstractWsdlRequestDesktopPanel.this.recreateButton.getAction());
            inputArea.getInputHandler().addKeyBinding("C+F4", AbstractWsdlRequestDesktopPanel.this.closePanelAction);
            inputArea.addFocusListener(new InputAreaFocusListener());
        }
    }

    private final class AttachmentPropertyChangeListener
    implements PropertyChangeListener {
        private AttachmentPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlRequest.ATTACHMENTS_PROPERTY)) {
                AbstractWsdlRequestDesktopPanel.this.requestEditorTabs.setTitleAt(1, "Request Attachments (" + AbstractWsdlRequestDesktopPanel.this.request.getAttachmentCount() + ")");
            } else if (evt.getPropertyName().equals(WsdlRequest.RESPONSE_PROPERTY)) {
                AbstractWsdlRequestDesktopPanel.this.responseEditorTabs.setTitleAt(1, "Response Attachments (" + (AbstractWsdlRequestDesktopPanel.this.request.getResponse() == null ? 0 : AbstractWsdlRequestDesktopPanel.this.request.getResponse().getAttachments().length) + ")");
            }
        }
    }
}

