/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mock;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public abstract class ListMouseListener
extends MouseAdapter {
    protected abstract ActionList getActionsForRow(JList var1, int var2);

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        JList list = (JList)e.getSource();
        int selectedIndex = list.getSelectedIndex();
        if (selectedIndex == -1) {
            return;
        }
        ActionList actions = this.getActionsForRow(list, selectedIndex);
        if (actions != null) {
            actions.performDefaultAction(new ActionEvent(this, 0, null));
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void showPopup(MouseEvent e) {
        ActionList actions;
        JList list = (JList)e.getSource();
        int row = list.locationToIndex(e.getPoint());
        if (row == -1) {
            return;
        }
        if (list.getSelectedIndex() != row) {
            list.setSelectedIndex(row);
        }
        if ((actions = this.getActionsForRow(list, row)) == null || actions.getActionCount() == 0) {
            return;
        }
        JPopupMenu popup = ActionSupport.buildPopup(actions);
        UISupport.showPopup(popup, list, e.getPoint());
    }
}

