/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.actions.iface.ExportDefinitionAction;
import com.eviware.soapui.impl.wsdl.actions.iface.UpdateInterfaceAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.ProgressDialog;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.syntax.jedit.JEditTextArea;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlInterfaceDesktopPanel
extends ModelItemDesktopPanel<WsdlInterface> {
    private static final Logger logger = Logger.getLogger(WsdlInterfaceDesktopPanel.class);
    private JTabbedPane tabbedPane;
    private List<JEditTextArea> editors = new ArrayList<JEditTextArea>();
    private JTree tree;
    private Map<String, DefaultMutableTreeNode> groupNodes = new HashMap<String, DefaultMutableTreeNode>();
    private Map<String, TreePath> pathMap = new HashMap<String, TreePath>();
    private List<TreePath> navigationHistory = new ArrayList<TreePath>();
    private StringList targetNamespaces = new StringList();
    public int historyIndex;
    public boolean navigating;
    private JEditorStatusBar statusBar;

    public WsdlInterfaceDesktopPanel(WsdlInterface iface) {
        super(iface);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(iface.getName());
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.tree = new JTree(treeModel);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeSelectionListener(new InternalTreeSelectionListener());
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                InspectItem item;
                DefaultMutableTreeNode treeNode;
                Object userObject;
                TreePath selectionPath;
                if (arg0.getClickCount() > 1 && (selectionPath = WsdlInterfaceDesktopPanel.this.tree.getSelectionPath()) != null && (userObject = (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof InspectItem && (item = (InspectItem)userObject) != null && item.selector != null) {
                    item.selector.selectNode(item);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        JSplitPane split = UISupport.createHorizontalSplit(scrollPane, UISupport.createTabPanel(this.tabbedPane, true));
        this.add((Component)split, "Center");
        split.setDividerLocation(250);
        split.setResizeWeight(0.3);
        try {
            if (iface.getWsdlContext().loadIfNecessary()) {
                XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Loading Defintion", 3, "Initializing definition..", true);
                Loader loader = new Loader(iface);
                if (progressDialog != null) {
                    progressDialog.setCancelLabel("Run in background");
                }
                progressDialog.run(loader);
                treeModel.nodeStructureChanged(rootNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add(this.buildToolbar(), "First");
        this.statusBar = new JEditorStatusBar();
        this.add((Component)this.statusBar, "Last");
        this.setPreferredSize(new Dimension(600, 500));
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(new JButton(new BackwardAction()));
        toolbar.addFixed(new JButton(new ForwardAction()));
        toolbar.addUnrelatedGap();
        JButton button = new JButton(new UpdateInterfaceAction((WsdlInterface)this.getModelItem()));
        button.setText(null);
        toolbar.addFixed(button);
        button = new JButton(new ExportDefinitionAction((WsdlInterface)this.getModelItem()));
        button.setText(null);
        toolbar.addFixed(button);
        toolbar.addGlue();
        button = new JButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/interfaces.html"));
        button.setText(null);
        toolbar.addFixed(button);
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlInterface)this.getModelItem()).getProject();
    }

    public List<DefaultMutableTreeNode> mapTreeItems(XmlObject xmlObject, DefaultMutableTreeNode treeRoot, boolean createEmpty, int tabIndex, String groupName, String query, String nameQuery, boolean sort, NodeSelector selector) {
        XmlObject[] items = xmlObject.selectPath(query);
        ArrayList<DefaultMutableTreeNode> treeNodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> resultNodes = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode root = treeRoot;
        if (groupName != null) {
            String groupKey = new TreePath(root.getPath()).toString() + "/" + groupName;
            if ((root = this.groupNodes.get(groupKey)) == null && (items.length > 0 || createEmpty)) {
                root = new DefaultMutableTreeNode(groupName);
                treeRoot.add(root);
                this.groupNodes.put(groupKey, root);
            } else if (root != null) {
                Enumeration<TreeNode> children = root.children();
                while (children.hasMoreElements()) {
                    treeNodes.add((DefaultMutableTreeNode)children.nextElement());
                }
            }
        }
        if (items.length == 0) {
            return resultNodes;
        }
        for (XmlObject item : items) {
            XmlObject[] selectPath = item.selectPath(nameQuery);
            if (selectPath.length <= 0) continue;
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new InspectItem(item, selectPath[0], tabIndex, selector));
            treeNodes.add(treeNode);
            resultNodes.add(treeNode);
        }
        if (sort) {
            Collections.sort(treeNodes, new Comparator<DefaultMutableTreeNode>(){

                @Override
                public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        }
        root.removeAllChildren();
        for (DefaultMutableTreeNode treeNode : treeNodes) {
            root.add(treeNode);
            String path = "/" + this.getTreeNodeName(treeNode);
            TreePath treePath = new TreePath(treeNode.getPath());
            while (treeNode.getParent() != null) {
                treeNode = (DefaultMutableTreeNode)treeNode.getParent();
                path = "/" + this.getTreeNodeName(treeNode) + path;
            }
            this.pathMap.put(path, treePath);
        }
        return resultNodes;
    }

    private String getTreeNodeName(DefaultMutableTreeNode treeNode) {
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof InspectItem) {
            return ((InspectItem)userObject).getName();
        }
        return treeNode.toString();
    }

    @Override
    public String getDescription() {
        return "Interface [" + ((WsdlInterface)this.getModelItem()).getName() + "]";
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return this.release();
    }

    private void simpleSelect(InspectItem item, String attribute, String targetGroup) {
        Element elm = item.getElement();
        String type = elm.getAttribute(attribute);
        if (type.length() > 0) {
            TreePath treePath;
            int ix = type.indexOf(58);
            if (ix != -1) {
                type = type.substring(ix + 1);
            }
            if ((treePath = this.pathMap.get("/" + ((WsdlInterface)this.getModelItem()).getName() + "/" + targetGroup + "/" + type)) != null) {
                this.tree.setSelectionPath(treePath);
            }
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super(">");
            this.putValue("ShortDescription", "Navigate to next selection");
        }

        public void actionPerformed(ActionEvent arg0) {
            if (WsdlInterfaceDesktopPanel.this.historyIndex < WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1) {
                ++WsdlInterfaceDesktopPanel.this.historyIndex;
                WsdlInterfaceDesktopPanel.this.navigating = true;
                WsdlInterfaceDesktopPanel.this.tree.setSelectionPath((TreePath)WsdlInterfaceDesktopPanel.this.navigationHistory.get(WsdlInterfaceDesktopPanel.this.historyIndex));
                WsdlInterfaceDesktopPanel.this.navigating = false;
            }
        }
    }

    private class BackwardAction
    extends AbstractAction {
        public BackwardAction() {
            super("<");
            this.putValue("ShortDescription", "Navigate to previous selection");
        }

        public void actionPerformed(ActionEvent arg0) {
            if (WsdlInterfaceDesktopPanel.this.historyIndex > 0) {
                --WsdlInterfaceDesktopPanel.this.historyIndex;
                WsdlInterfaceDesktopPanel.this.navigating = true;
                WsdlInterfaceDesktopPanel.this.tree.setSelectionPath((TreePath)WsdlInterfaceDesktopPanel.this.navigationHistory.get(WsdlInterfaceDesktopPanel.this.historyIndex));
                WsdlInterfaceDesktopPanel.this.navigating = false;
            }
        }
    }

    public class BindingOperationSelector
    implements NodeSelector {
        public void selectNode(InspectItem item) {
            Element elm = item.getElement();
            String name = elm.getAttribute("name");
            Element operationElm = (Element)elm.getParentNode();
            Element bindingElm = (Element)operationElm.getParentNode();
            String type = bindingElm.getAttribute("type");
            if (type.length() > 0) {
                TreePath treePath;
                int ix = type.indexOf(58);
                if (ix != -1) {
                    type = type.substring(ix + 1);
                }
                if ((treePath = (TreePath)WsdlInterfaceDesktopPanel.this.pathMap.get("/" + ((WsdlInterface)WsdlInterfaceDesktopPanel.this.getModelItem()).getName() + "/PortTypes/" + type + "/" + operationElm.getAttribute("name") + "/" + name)) != null) {
                    WsdlInterfaceDesktopPanel.this.tree.setSelectionPath(treePath);
                }
            }
        }
    }

    public class PortSelector
    implements NodeSelector {
        public void selectNode(InspectItem item) {
            WsdlInterfaceDesktopPanel.this.simpleSelect(item, "binding", "Bindings");
        }
    }

    public class GlobalElementSelector
    implements NodeSelector {
        public void selectNode(InspectItem item) {
            WsdlInterfaceDesktopPanel.this.simpleSelect(item, "type", "Complex Types");
        }
    }

    public class MessageSelector
    implements NodeSelector {
        public void selectNode(InspectItem item) {
            WsdlInterfaceDesktopPanel.this.simpleSelect(item, "message", "Messages");
        }
    }

    public class PartSelector
    implements NodeSelector {
        public void selectNode(InspectItem item) {
            Element elm = item.getElement();
            String type = elm.getAttribute("type");
            String element = elm.getAttribute("element");
            if (type.length() > 0) {
                WsdlInterfaceDesktopPanel.this.simpleSelect(item, "type", "Complex Types");
            } else if (element.length() > 0) {
                WsdlInterfaceDesktopPanel.this.simpleSelect(item, "element", "Global Elements");
            }
        }
    }

    public static interface NodeSelector {
        public void selectNode(InspectItem var1);
    }

    private final class InspectItem {
        private final XmlObject item;
        private String name;
        private final int tabIndex;
        private XmlLineNumber lineNumber;
        private final NodeSelector selector;

        public InspectItem(XmlObject item, XmlObject nameObj, int tabIndex, NodeSelector selector) {
            this.item = item;
            this.selector = selector;
            this.name = XmlUtils.getNodeValue(nameObj.getDomNode());
            if (this.name == null) {
                this.name = nameObj.toString();
            }
            this.tabIndex = tabIndex;
            ArrayList list = new ArrayList();
            XmlCursor cursor = item.newCursor();
            cursor.getAllBookmarkRefs(list);
            for (Object o : list) {
                if (!(o instanceof XmlLineNumber)) continue;
                this.lineNumber = (XmlLineNumber)o;
            }
            cursor.dispose();
        }

        public String getDescription() {
            return this.getName() + "@" + (String)WsdlInterfaceDesktopPanel.this.targetNamespaces.get(this.tabIndex);
        }

        public String getName() {
            int ix = this.name.indexOf(32);
            return ix == -1 ? this.name : this.name.substring(0, ix);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getLineNumber() {
            return this.lineNumber == null ? -1 : this.lineNumber.getLine() - 1;
        }

        public String toString() {
            return this.name;
        }

        public NodeSelector getSelector() {
            return this.selector;
        }

        public Element getElement() {
            return (Element)this.item.getDomNode();
        }
    }

    private class Loader
    implements Worker {
        private ProgressDialog progressDialog;
        private final WsdlInterface iface;
        private JProgressBar progressBar;

        public Loader(WsdlInterface iface) {
            this.iface = iface;
        }

        public Object construct(XProgressMonitor monitor) {
            try {
                Map<String, XmlObject> schemas = this.iface.getWsdlContext().getDefinitionParts();
                int tabCount = WsdlInterfaceDesktopPanel.this.tabbedPane.getTabCount();
                for (String url : schemas.keySet()) {
                    this.addTab(url, schemas.get(url));
                }
                while (tabCount-- > 0) {
                    WsdlInterfaceDesktopPanel.this.tabbedPane.remove(0);
                }
                return null;
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load WSDL; " + e.getClass().getSimpleName() + "; " + e.getMessage()));
                WsdlInterfaceDesktopPanel.this.add((Component)new JLabel("Failed to load WSDL; " + e.toString()), "North");
                e.printStackTrace();
                return e;
            }
        }

        private void addTab(String url, XmlObject xmlObject) throws Exception {
            int ix = url.startsWith("file:") ? url.lastIndexOf(File.separatorChar) : url.lastIndexOf(47);
            String title = url.substring(ix + 1);
            if (this.progressBar != null) {
                this.progressBar.setString(title);
            } else if (this.progressDialog != null) {
                this.progressDialog.setProgress(1, title);
            }
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(url);
            label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            panel.add((Component)label, "North");
            JXEditTextArea inputArea = JXEditTextArea.createXmlEditor();
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(xmlObject, (Writer)writer);
            String xmlString = writer.toString();
            xmlObject = XmlObject.Factory.parse((String)xmlString, (XmlOptions)new XmlOptions().setLoadLineNumbers());
            inputArea.setText(xmlString);
            inputArea.setEditable(false);
            inputArea.getPainter().setLineHighlightEnabled(true);
            panel.add((Component)new JScrollPane(inputArea), "Center");
            WsdlInterfaceDesktopPanel.this.tabbedPane.addTab(title, panel);
            if (WsdlInterfaceDesktopPanel.this.tree != null) {
                this.initInspectionTree(xmlObject, inputArea);
            }
        }

        private void initInspectionTree(XmlObject xmlObject, JXEditTextArea inputArea) {
            DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)WsdlInterfaceDesktopPanel.this.tree.getModel().getRoot();
            WsdlInterfaceDesktopPanel.this.targetNamespaces.add(SchemaUtils.getTargetNamespace(xmlObject));
            int tabCount = WsdlInterfaceDesktopPanel.this.tabbedPane.getTabCount() - 1;
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Complex Types", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:complexType[@name!='']", "@name", true, null);
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Anonymous Complex Types", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:complexType[not(exists(@name))]", "parent::node()/@name", true, null);
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Global Elements", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:schema/xs:element[@name!='']", "@name", true, new GlobalElementSelector());
            WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Schemas", "declare namespace xs='http://www.w3.org/2001/XMLSchema';//xs:schema", "@targetNamespace", true, null);
            List<DefaultMutableTreeNode> messages = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Messages", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:message", "@name", true, null);
            for (DefaultMutableTreeNode treeNode : messages) {
                WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode.getUserObject()).item, treeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:part", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';concat('part: name=[', @name, '] type=[', @type, '] element=[', @element, ']' )", true, new PartSelector());
            }
            List<DefaultMutableTreeNode> portTypes = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "PortTypes", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:portType", "@name", true, null);
            for (DefaultMutableTreeNode treeNode : portTypes) {
                List<DefaultMutableTreeNode> operationNodes = WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode.getUserObject()).item, treeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:operation", "@name", true, null);
                for (DefaultMutableTreeNode treeNode2 : operationNodes) {
                    WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode2.getUserObject()).item, treeNode2, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:*", "concat( @name, ' [', local-name(), '], message=[', @message, ']' )", false, new MessageSelector());
                }
            }
            List<DefaultMutableTreeNode> bindings = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Bindings", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:binding", "declare namespace wsdlsoap='http://schemas.xmlsoap.org/wsdl/soap/';concat( @name, ' [style=', wsdlsoap:binding/@style, ']' )", true, null);
            for (DefaultMutableTreeNode treeNode : bindings) {
                List<DefaultMutableTreeNode> operationNodes = WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode.getUserObject()).item, treeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:operation", "declare namespace wsdlsoap='http://schemas.xmlsoap.org/wsdl/soap/';concat( @name, ' [soapAction=', wsdlsoap:operation/@soapAction, ']' )", true, null);
                for (DefaultMutableTreeNode treeNode2 : operationNodes) {
                    WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode2.getUserObject()).item, treeNode2, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:*", "concat( @name, ' [', local-name(), ']' )", false, new BindingOperationSelector());
                }
            }
            List<DefaultMutableTreeNode> services = WsdlInterfaceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Services", "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';//wsdl:service", "@name", true, null);
            for (DefaultMutableTreeNode treeNode : services) {
                WsdlInterfaceDesktopPanel.this.mapTreeItems(((InspectItem)treeNode.getUserObject()).item, treeNode, false, tabCount, null, "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/';wsdl:port", "concat( 'port: name=[', @name, '] binding=[', @binding, ']' )", true, new PortSelector());
            }
            WsdlInterfaceDesktopPanel.this.tree.expandRow(0);
            WsdlInterfaceDesktopPanel.this.editors.add(inputArea);
        }

        public void finished() {
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
        }

        public boolean onCancel() {
            this.progressBar = new JProgressBar(0, 1);
            this.progressBar.setSize(new Dimension(120, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("Loading Definition..");
            this.progressBar.setIndeterminate(true);
            ButtonBarBuilder builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            builder.addFixed((JComponent)this.progressBar);
            builder.addGlue();
            builder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            WsdlInterfaceDesktopPanel.this.tabbedPane.addTab("Loading.. ", builder.getPanel());
            return true;
        }
    }

    private final class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
            if (newLeadSelectionPath != null) {
                DefaultMutableTreeNode tn;
                if (!WsdlInterfaceDesktopPanel.this.navigating) {
                    while (WsdlInterfaceDesktopPanel.this.historyIndex < WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1) {
                        TreePath path = (TreePath)WsdlInterfaceDesktopPanel.this.navigationHistory.remove(WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1);
                        WsdlInterfaceDesktopPanel.this.navigationHistory.add(WsdlInterfaceDesktopPanel.this.historyIndex++, path);
                    }
                    WsdlInterfaceDesktopPanel.this.navigationHistory.add(newLeadSelectionPath);
                    WsdlInterfaceDesktopPanel.this.historyIndex = WsdlInterfaceDesktopPanel.this.navigationHistory.size() - 1;
                }
                if ((tn = (DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent()).getUserObject() instanceof InspectItem) {
                    InspectItem item = (InspectItem)tn.getUserObject();
                    WsdlInterfaceDesktopPanel.this.tabbedPane.setSelectedIndex(item.getTabIndex());
                    WsdlInterfaceDesktopPanel.this.statusBar.setInfo(item.getDescription());
                    JEditTextArea editor = (JEditTextArea)WsdlInterfaceDesktopPanel.this.editors.get(item.getTabIndex());
                    int lineNumber = item.getLineNumber();
                    if (lineNumber > 0 && editor.getLineStartOffset(lineNumber) >= 0) {
                        editor.setCaretPosition(editor.getLineStartOffset(lineNumber));
                    } else {
                        editor.setCaretPosition(0);
                    }
                }
                WsdlInterfaceDesktopPanel.this.tree.scrollPathToVisible(newLeadSelectionPath);
                WsdlInterfaceDesktopPanel.this.tree.expandPath(newLeadSelectionPath);
            }
        }
    }
}

