/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MockRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class WsdlMockRequest
implements MockRequest {
    private StringToStringMap requestHeaders;
    private String requestContent;
    private MultipartMessageSupport mmSupport;
    private XmlObject requestXmlObject;
    private SoapVersion soapVersion;
    private final HttpServletResponse response;
    private String protocol;
    private String path;
    private final WsdlMockRunContext context;
    private final HttpServletRequest request;

    public WsdlMockRequest(HttpServletRequest request, HttpServletResponse response, WsdlMockRunContext context) throws Exception {
        this.request = request;
        this.response = response;
        this.context = context;
        this.requestHeaders = new StringToStringMap();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            this.requestHeaders.put(header, request.getHeader(header));
        }
        this.protocol = request.getProtocol();
        this.path = request.getPathInfo();
        String contentType = request.getContentType();
        if (contentType != null && contentType.toUpperCase().startsWith("MULTIPART")) {
            this.readMultipartRequest(request);
            contentType = this.mmSupport.getRootPart().getContentType();
        } else {
            this.requestContent = this.readRequestContent(request);
        }
        this.initSoapVersion(contentType);
    }

    protected boolean initSoapVersion(String contentType) {
        this.soapVersion = contentType.startsWith(SoapVersion.Soap11.getContentType()) ? SoapVersion.Soap11 : null;
        this.soapVersion = this.soapVersion == null && contentType.startsWith(SoapVersion.Soap12.getContentType()) ? SoapVersion.Soap12 : this.soapVersion;
        return true;
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void readMultipartRequest(HttpServletRequest request) throws MessagingException {
        StringToStringMap values = StringToStringMap.fromHttpHeader(request.getContentType());
        this.mmSupport = new MultipartMessageSupport(new MockRequestDataSource(request), (String)values.get("start"));
    }

    private String readRequestContent(HttpServletRequest request) throws Exception {
        String encoding = request.getCharacterEncoding();
        encoding = encoding == null ? "UTF-8" : StringUtils.unquote(encoding);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), encoding));
        StringBuffer buf = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            buf.append(line).append("\r\n");
            line = reader.readLine();
        }
        return buf.toString();
    }

    public Attachment[] getRequestAttachments() {
        return this.mmSupport == null ? new Attachment[]{} : this.mmSupport.getAttachments();
    }

    public String getRequestContent() {
        return this.mmSupport == null ? this.requestContent : this.mmSupport.getContentAsString();
    }

    public StringToStringMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public XmlObject getRequestXmlObject() throws XmlException {
        if (this.requestXmlObject == null) {
            this.requestXmlObject = XmlObject.Factory.parse((String)this.getRequestContent());
        }
        return this.requestXmlObject;
    }

    public XmlObject getBodyElement() throws XmlException {
        XmlObject[] envelope = this.getRequestXmlObject().selectChildren(this.soapVersion.getEnvelopeQName());
        if (envelope.length != 1) {
            throw new XmlException("Missing/Invalid SOAP Envelope, expecting [" + this.soapVersion.getEnvelopeQName() + "]");
        }
        XmlObject[] body = envelope[0].selectChildren(this.soapVersion.getBodyQName());
        if (body.length != 1) {
            throw new XmlException("Missing/Invalid SOAP Body, expecting [" + this.soapVersion.getBodyQName() + "]");
        }
        return body[0];
    }

    public HttpServletResponse getHttpResponse() {
        return this.response;
    }

    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlObject getContentElement() throws XmlException {
        XmlObject bodyElement = this.getBodyElement();
        if (bodyElement != null) {
            XmlCursor cursor = bodyElement.newCursor();
            try {
                if (cursor.toFirstChild()) {
                    while (!cursor.isContainer()) {
                        cursor.toNextSibling();
                    }
                    if (cursor.isContainer()) {
                        XmlObject xmlObject = cursor.getObject();
                        return xmlObject;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cursor.dispose();
            }
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public WsdlMockRunContext getContext() {
        return this.context;
    }
}

