/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.log;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractListModel;

public class LoadTestLog
extends AbstractListModel
implements Runnable {
    private List<LoadTestLogEntry> entries = Collections.synchronizedList(new ArrayList());
    private final WsdlLoadTest loadTest;
    private int totalErrorCount;
    private Map<String, Integer> errorCounts = new HashMap<String, Integer>();
    private Stack<LoadTestLogEntry> entriesStack = new Stack();
    private Thread modelThread;
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();

    public LoadTestLog(WsdlLoadTest loadTest) {
        this.loadTest = loadTest;
        loadTest.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
    }

    public void release() {
        this.loadTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    public int getSize() {
        return this.entries.size();
    }

    public Object getElementAt(int index) {
        return this.entries.get(index);
    }

    public synchronized void addEntry(LoadTestLogEntry entry) {
        this.entriesStack.push(entry);
        if (this.modelThread == null) {
            this.modelThread = new Thread(this);
            this.modelThread.start();
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (!this.entriesStack.isEmpty()) {
                        int cnt = 0;
                        while (cnt < 10 && !this.entriesStack.isEmpty()) {
                            LoadTestLogEntry entry = this.entriesStack.pop();
                            if (entry == null) continue;
                            this.entries.add(entry);
                            if (entry.isError()) {
                                ++this.totalErrorCount;
                                TestStep targetStep = entry.getTargetStep();
                                String stepName = targetStep == null ? "- Total -" : targetStep.getName();
                                Integer errorCount = this.errorCounts.get(stepName);
                                errorCount = errorCount == null ? Integer.valueOf(1) : Integer.valueOf(errorCount + 1);
                                this.errorCounts.put(stepName, errorCount);
                            }
                            ++cnt;
                        }
                        if (cnt <= 0) continue;
                        this.fireIntervalAdded(this, this.entries.size() - cnt, this.entries.size() - 1);
                        continue;
                    }
                    Thread.sleep(200L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void clear() {
        this.entriesStack.clear();
        if (!this.entries.isEmpty()) {
            int size = this.entries.size();
            this.entries.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
            this.totalErrorCount = 0;
            this.errorCounts.clear();
        }
    }

    public void clearErrors() {
        int sz = this.entries.size();
        for (int c = 0; c < this.entries.size(); ++c) {
            if (!this.entries.get(c).isError()) continue;
            this.entries.remove(c);
            --c;
        }
        this.totalErrorCount = 0;
        this.errorCounts.clear();
        if (sz > this.entries.size()) {
            this.fireIntervalRemoved(this, this.entries.size(), sz);
            this.fireContentsChanged(this, 0, this.entries.size());
        }
    }

    public void clearEntries(TestStep testStep) {
        int sz = this.entries.size();
        String testStepName = testStep.getName();
        for (int c = 0; c < this.entries.size(); ++c) {
            if (this.entries.get(c).getTargetStep() == null || !testStepName.equals(this.entries.get(c).getTargetStep().getName())) continue;
            this.entries.remove(c);
            --c;
        }
        if (this.errorCounts.containsKey(testStepName)) {
            this.totalErrorCount -= this.errorCounts.get(testStepName).intValue();
            this.errorCounts.remove(testStepName);
        }
        if (sz > this.entries.size()) {
            this.fireIntervalRemoved(this, this.entries.size(), sz);
            this.fireContentsChanged(this, 0, this.entries.size());
        }
    }

    public WsdlLoadTest getLoadTest() {
        return this.loadTest;
    }

    public int getErrorCount(String stepName) {
        if (stepName == null) {
            return this.totalErrorCount;
        }
        Integer counts = this.errorCounts.get(stepName);
        return counts == null ? 0 : counts;
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == LoadTestLog.this.loadTest.getTestCase()) {
                LoadTestLog.this.clearEntries(testStep);
            }
        }
    }
}

