/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class CloneTestCaseAction
extends AbstractAction {
    private final WsdlTestCase testCase;

    public CloneTestCaseAction(WsdlTestCase testCase) {
        super("Clone TestCase");
        this.testCase = testCase;
        this.putValue("ShortDescription", "Clones this TestCase");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("F9"));
    }

    public void actionPerformed(ActionEvent e) {
        String name = UISupport.prompt("Specify name of cloned TestCase", "Clone TestCase", "Copy of " + this.testCase.getName());
        if (name == null) {
            return;
        }
        WsdlProject project = this.testCase.getTestSuite().getProject();
        if (project.getTestSuiteCount() > 1) {
            ArrayList<String> names = new ArrayList<String>();
            for (int c = 0; c < project.getTestSuiteCount(); ++c) {
                names.add(project.getTestSuiteAt(c).getName());
            }
            String testSuite = (String)UISupport.prompt("Select target TestSuite", "Clone TestCase", names.toArray(), this.testCase.getTestSuite().getName());
            if (testSuite == null) {
                return;
            }
            WsdlTestSuite targetSuite = (WsdlTestSuite)project.getTestSuiteAt(names.indexOf(testSuite));
            WsdlTestCase newTestCase = targetSuite.cloneTestCase(this.testCase, name);
            SoapUI.selectModelItem(newTestCase);
        } else {
            WsdlTestCase newTestCase = this.testCase.getTestSuite().cloneTestCase(this.testCase, name);
            SoapUI.selectModelItem(newTestCase);
        }
    }
}

