/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;

public class RemoveProjectAction
extends AbstractAction {
    private final WsdlProject project;

    public RemoveProjectAction(WsdlProject project) {
        super("Remove");
        this.project = project;
        this.putValue("ShortDescription", "Removes this project from the workspace");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("DELETE"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.hasRunningTests()) {
            UISupport.showErrorMessage("Cannot remove Interface due to running tests");
            return;
        }
        Boolean retval = UISupport.confirmOrCancel("Save project [" + this.project.getName() + "] before removing?", "Remove Project");
        if (retval == null) {
            return;
        }
        if (retval.booleanValue()) {
            try {
                this.project.save();
            }
            catch (IOException e1) {
                UISupport.showErrorMessage(e1);
            }
        }
        this.project.getWorkspace().removeProject(this.project);
    }

    private boolean hasRunningTests() {
        for (int c = 0; c < this.project.getTestSuiteCount(); ++c) {
            WsdlTestSuite testSuite = this.project.getTestSuiteAt(c);
            for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
                if (!SoapUI.getTestMonitor().hasRunningTest(testSuite.getTestCaseAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

