/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class AddInterfaceActionFromFile
extends AbstractAction {
    private final WsdlProject project;

    public AddInterfaceActionFromFile(WsdlProject project) {
        super("Add WSDL from File");
        this.project = project;
        this.putValue("ShortDescription", "Adds all interfaces in a specified local WSDL file to the current project");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu F"));
    }

    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().open(this, "Select WSDL file", ".wsdl", "WSDL Files (*.wsdl)");
        if (file == null) {
            return;
        }
        String url = file.getAbsolutePath();
        if (url == null) {
            return;
        }
        try {
            Boolean createRequests = UISupport.confirmOrCancel("Create default requests for all operations", "Import WSDL");
            if (createRequests == null) {
                return;
            }
            WsdlInterface[] ifaces = this.project.importWsdl("file:" + url, createRequests);
            if (ifaces.length > 0) {
                SoapUI.selectModelItem(ifaces[0]);
            }
        }
        catch (Exception ex) {
            UISupport.showErrorMessage(ex.getMessage() + ":" + ex.getCause());
        }
    }
}

