/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.loadtest;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class LoadTestOptionsAction
extends AbstractAction {
    private static final String THREAD_STARTUP_DELAY = "Thread startup delay";
    private static final String RESET_STATISTICS = "Reset statistics";
    private static final String CALC_TPS = "Calculate TPS/BPS";
    private static final String INCLUDE_REQUEST = "Include request write";
    private static final String INCLUDE_RESPONSE = "Include response read";
    private static final String CLOSE_CONNECTIONS = "Close connections";
    private static final String SAMPLE_INTERVAL = "Sample interval";
    private final WsdlLoadTest loadTest;
    private XFormDialog dialog;

    public LoadTestOptionsAction(WsdlLoadTest loadTest) {
        this.loadTest = loadTest;
        this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
        this.putValue("ShortDescription", "Sets options for this LoadTest");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(THREAD_STARTUP_DELAY, String.valueOf(this.loadTest.getStartDelay()));
        values.put(RESET_STATISTICS, String.valueOf(this.loadTest.getResetStatisticsOnThreadCountChange()));
        values.put(CALC_TPS, String.valueOf(this.loadTest.getCalculateTPSOnTimePassed()));
        values.put(SAMPLE_INTERVAL, String.valueOf(this.loadTest.getSampleInterval()));
        Settings settings = this.loadTest.getSettings();
        values.put(INCLUDE_REQUEST, String.valueOf(settings.getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN)));
        values.put(INCLUDE_RESPONSE, String.valueOf(settings.getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN)));
        values.put(CLOSE_CONNECTIONS, String.valueOf(settings.getBoolean(HttpSettings.CLOSE_CONNECTIONS)));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                this.loadTest.setStartDelay(Integer.parseInt((String)values.get(THREAD_STARTUP_DELAY)));
                this.loadTest.setResetStatisticsOnThreadCountChange(Boolean.parseBoolean((String)values.get(RESET_STATISTICS)));
                this.loadTest.setCalculateTPSOnTimePassed(Boolean.parseBoolean((String)values.get(CALC_TPS)));
                this.loadTest.setSampleInterval(Integer.parseInt((String)values.get(SAMPLE_INTERVAL)));
                settings.setBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, Boolean.parseBoolean((String)values.get(INCLUDE_REQUEST)));
                settings.setBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, Boolean.parseBoolean((String)values.get(INCLUDE_RESPONSE)));
                settings.setBoolean(HttpSettings.CLOSE_CONNECTIONS, Boolean.parseBoolean((String)values.get(CLOSE_CONNECTIONS)));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("LoadTest Options");
        XForm form = builder.createForm("Basic");
        form.addTextField(THREAD_STARTUP_DELAY, "The delay before starting a thread in ms", XForm.FieldType.TEXT).setWidth(10);
        form.addCheckBox(RESET_STATISTICS, "when the number of threads changes");
        form.addCheckBox(CALC_TPS, "based on actual time passed");
        form.addCheckBox(INCLUDE_REQUEST, "in calculated time");
        form.addCheckBox(INCLUDE_RESPONSE, "in calculated time");
        form.addCheckBox(CLOSE_CONNECTIONS, "after each request");
        form.addTextField(SAMPLE_INTERVAL, "the frequency of statistics updates in ms", XForm.FieldType.TEXT).setWidth(10);
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/userguide/loadtest/index.html#LoadTest_Options"), "Specify general options for this LoadTest", UISupport.TOOL_ICON);
    }
}

