/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.UISupport;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class InterfaceEndpointsAction
extends AbstractAction {
    private JDialog dialog;
    private JList list;
    private WsdlInterface iface;
    private DefaultListModel listModel;
    private static final Logger log = Logger.getLogger(InterfaceEndpointsAction.class);

    public InterfaceEndpointsAction(WsdlInterface iface) {
        super("Service Endpoints");
        this.putValue("ShortDescription", "Manage service endpoints available for this interface");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu E"));
        this.iface = iface;
    }

    private void buildDialog() {
        this.dialog = new JDialog(UISupport.getMainFrame());
        this.dialog.setTitle("Interface Service Endpoints");
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.list.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), BorderFactory.createLineBorder(Color.GRAY)));
        scrollPane.setVerticalScrollBarPolicy(22);
        contentPanel.add((Component)scrollPane, "Center");
        contentPanel.add(this.createButtons(), "South");
        JLabel label = new JLabel("Edit available service endpoints for this interface in list below");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)label, "North");
        this.dialog.setContentPane(contentPanel);
        this.dialog.setSize(400, 300);
        this.dialog.setModal(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.listModel.clear();
        String[] endpoints = this.iface.getEndpoints();
        for (int c = 0; c < endpoints.length; ++c) {
            this.listModel.addElement(endpoints[c]);
        }
        UISupport.showDialog(this.dialog);
    }

    private Component createButtons() {
        ButtonBarBuilder builder = ButtonBarBuilder.createLeftToRightBuilder();
        builder.addFixed((JComponent)new JButton(new AddAction()));
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new EditAction()));
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new DeleteAction()));
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new AssignAction()));
        builder.addGlue();
        builder.addFixed((JComponent)new JButton(new OkAction()));
        builder.addRelatedGap();
        builder.addFixed((JComponent)UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/interfaces.html#Service_Endpoints")));
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return builder.getPanel();
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent e) {
            InterfaceEndpointsAction.this.dialog.setVisible(false);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
        }

        public void actionPerformed(ActionEvent e) {
            int index = InterfaceEndpointsAction.this.list.getSelectedIndex();
            if (index == -1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (UISupport.confirm("Delete selected endpoint?", "Delete Endpoint")) {
                String oldEndpoint = (String)InterfaceEndpointsAction.this.listModel.getElementAt(index);
                InterfaceEndpointsAction.this.listModel.removeElementAt(index);
                InterfaceEndpointsAction.this.iface.removeEndpoint(oldEndpoint);
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            super("Edit");
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = InterfaceEndpointsAction.this.list.getSelectedIndex();
            if (selectedIndex == -1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String oldEndpoint = (String)InterfaceEndpointsAction.this.listModel.getElementAt(selectedIndex);
            String newEndpoint = UISupport.prompt("Edit endpoint address", "Edit Endpoint", oldEndpoint);
            if (newEndpoint == null) {
                return;
            }
            InterfaceEndpointsAction.this.listModel.setElementAt(newEndpoint, selectedIndex);
            InterfaceEndpointsAction.this.iface.changeEndpoint(oldEndpoint, newEndpoint);
        }
    }

    private class AssignAction
    extends AbstractAction {
        private static final String ALL_REQUESTS = "- all requests -";
        private static final String ALL_REQUESTS_WITH_NO_ENDPOINT = "- all requests with no endpoint -";

        public AssignAction() {
            super("Assign");
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = InterfaceEndpointsAction.this.list.getSelectedIndex();
            if (selectedIndex == -1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String selectedEndpoint = (String)InterfaceEndpointsAction.this.listModel.getElementAt(selectedIndex);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(InterfaceEndpointsAction.this.iface.getEndpoints()));
            list.add(0, ALL_REQUESTS);
            list.add(0, ALL_REQUESTS_WITH_NO_ENDPOINT);
            Object endpoint = UISupport.prompt("Assign selected endpoint to..", "Assign Endpoint", list.toArray(), ALL_REQUESTS_WITH_NO_ENDPOINT);
            if (endpoint == null) {
                return;
            }
            int changeCount = 0;
            for (int c = 0; c < InterfaceEndpointsAction.this.iface.getOperationCount(); ++c) {
                WsdlOperation operation = InterfaceEndpointsAction.this.iface.getOperationAt(c);
                for (int i = 0; i < operation.getRequestCount(); ++i) {
                    Request request = operation.getRequestAt(i);
                    String ep = request.getEndpoint();
                    if (!endpoint.equals(ALL_REQUESTS) && (!endpoint.equals(ALL_REQUESTS_WITH_NO_ENDPOINT) || ep != null) && !ep.equals(endpoint)) continue;
                    request.setEndpoint(selectedEndpoint);
                    ++changeCount;
                }
            }
            log.info((Object)("Assigned endpoint [" + selectedEndpoint + "] to " + changeCount + " requests"));
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent e) {
            Object selectedValue = InterfaceEndpointsAction.this.list.getSelectedValue();
            String endpoint = UISupport.prompt("Enter new endpoint address", "Add Endpoint", selectedValue == null ? "" : selectedValue.toString());
            if (endpoint == null) {
                return;
            }
            InterfaceEndpointsAction.this.listModel.addElement(endpoint);
            InterfaceEndpointsAction.this.iface.addEndpoint(endpoint);
        }
    }
}

