/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.support.wsdl.CachedWsdlLoader;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class ExportDefinitionAction
extends AbstractAction {
    private final WsdlInterface iface;

    public ExportDefinitionAction(WsdlInterface iface) {
        super("Export Definition");
        this.iface = iface;
        this.putValue("SmallIcon", UISupport.createImageIcon("/exportDefinition.gif"));
        this.putValue("ShortDescription", "Exports the entire WSDL and included/imported files to a local directory");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu P"));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.exportDefinition(null) != null) {
                UISupport.showInfoMessage("Definition exported succesfully");
            }
        }
        catch (Exception e1) {
            UISupport.showErrorMessage(e1);
        }
    }

    public String exportDefinition(String location) throws Exception {
        File folderName;
        File file = folderName = location == null ? UISupport.getFileDialogs().openDirectory(this, "Select output directory", null) : new File(location);
        if (folderName == null) {
            return null;
        }
        CachedWsdlLoader loader = null;
        loader = this.iface.isCached() ? (CachedWsdlLoader)this.iface.createWsdlLoader() : new CachedWsdlLoader(this.iface.getDefinition());
        return loader.saveDefinition(folderName.getAbsolutePath());
    }
}

