/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.components.DirectoryFormComponent;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;

public class ToolsPrefs
implements Prefs {
    public static final String AXIS_1_X = "Axis 1.X";
    public static final String WSCOMPILE = "JAX-RPC WSCompile";
    public static final String WSIMPORT = "JAX-WS WSImport";
    public static final String AXIS_2 = "Axis 2";
    public static final String WSTOOLS = "JBossWS wstools";
    public static final String JAVAC = "JDK 1.5 javac";
    public static final String DOTNET = ".NET 2.0 wsdl.exe";
    public static final String XFIRE = "XFire 1.X";
    public static final String GSOAP = "GSoap";
    public static final String ANT = "ANT 1.6.5";
    public static final String XMLBEANS = "XmlBeans 2.X";
    public static final String JAXB = "JAXB xjc";
    public static final String TCPMON = "Apache TcpMon";
    public static final String WSA = "Oracle wsa.jar";
    public static final String LIBRARIES = "Script libraries";
    private static final String[][] TOOLS = new String[][]{{"JBossWS wstools", ToolsSettings.JBOSSWS_WSTOOLS_LOCATION}, {"Axis 1.X", ToolsSettings.AXIS_1_X_LOCATION}, {"Axis 2", ToolsSettings.AXIS_2_LOCATION}, {"JAX-RPC WSCompile", ToolsSettings.JWSDP_WSCOMPILE_LOCATION}, {"JAX-WS WSImport", ToolsSettings.JWSDP_WSIMPORT_LOCATION}, {"JDK 1.5 javac", ToolsSettings.JAVAC_LOCATION}, {".NET 2.0 wsdl.exe", ToolsSettings.DOTNET_WSDL_LOCATION}, {"XFire 1.X", ToolsSettings.XFIRE_LOCATION}, {"GSoap", ToolsSettings.GSOAP_LOCATION}, {"ANT 1.6.5", ToolsSettings.ANT_LOCATION}, {"XmlBeans 2.X", ToolsSettings.XMLBEANS_LOCATION}, {"JAXB xjc", ToolsSettings.JAXB_LOCATION}, {"Apache TcpMon", ToolsSettings.TCPMON_LOCATION}, {"Oracle wsa.jar", ToolsSettings.ORACLE_WSA_LOCATION}};
    private SimpleForm toolsForm;
    private final String title;

    public ToolsPrefs(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String[][] getEclipseTools() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String[] s : TOOLS) {
            String tool = s[0];
            if (tool == DOTNET || tool == GSOAP || tool == JAVAC || tool == ANT) continue;
            list.add(s);
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    public SimpleForm getForm() {
        if (this.toolsForm == null) {
            this.toolsForm = new SimpleForm();
            this.toolsForm.addSpace(5);
            this.toolsForm.append(WSTOOLS, new DirectoryFormComponent("location of JBossWS wstools"));
            this.toolsForm.append(WSCOMPILE, new DirectoryFormComponent("location of JWSDP wscompile"));
            this.toolsForm.append(WSIMPORT, new DirectoryFormComponent("location of JAX-WS wsimport"));
            this.toolsForm.append(AXIS_1_X, new DirectoryFormComponent("location of Axis 1.X"));
            this.toolsForm.append(AXIS_2, new DirectoryFormComponent("location of Axis 2"));
            this.toolsForm.append(DOTNET, new DirectoryFormComponent("location of .NET 2.0 wsdl.exe"));
            this.toolsForm.append(XFIRE, new DirectoryFormComponent("location of XFire 1.X"));
            this.toolsForm.append(ANT, new DirectoryFormComponent("location of Apache ANT 1.6.5"));
            this.toolsForm.append(GSOAP, new DirectoryFormComponent("location of GSoap 2.X"));
            this.toolsForm.append(JAXB, new DirectoryFormComponent("location of JAXB xjc"));
            this.toolsForm.append(XMLBEANS, new DirectoryFormComponent("location of XMLBeans 2.X"));
            this.toolsForm.append(JAVAC, new DirectoryFormComponent("location of JDK 1.5 javac"));
            this.toolsForm.append(TCPMON, new DirectoryFormComponent("location of TcpMon directory"));
            this.toolsForm.append(WSA, new DirectoryFormComponent("location of Orace wsa.jar"));
            this.toolsForm.addSpace(5);
        }
        return this.toolsForm;
    }

    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.toolsForm.getValues(values);
        this.storeValues(values, settings);
    }

    public void storeValues(StringToStringMap values, Settings settings) {
        for (int i = 0; i < TOOLS.length; ++i) {
            settings.setString(TOOLS[i][1], (String)values.get(TOOLS[i][0]));
        }
    }

    public void setFormValues(Settings settings) {
        this.getForm().setValues(this.getValues(settings));
    }

    public StringToStringMap getValues(Settings settings) {
        StringToStringMap toolsValues = new StringToStringMap();
        for (int i = 0; i < TOOLS.length; ++i) {
            toolsValues.put(TOOLS[i][0], settings.getString(TOOLS[i][1], ""));
        }
        return toolsValues;
    }
}

