/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;

public class HttpPrefs
implements Prefs {
    public static final String AUTHENTICATE_PREEMPTIVELY = "Authenticate Preemptively";
    public static final String INCLUDE_REQUEST_IN_TIME_TAKEN = "Include request in time taken";
    public static final String INCLUDE_RESPONSE_IN_TIME_TAKEN = "Include response in time taken";
    public static final String CLOSE_CONNECTIONS_AFTER_REQUEST = "Close connections after request";
    public static final String USER_AGENT_HEADER = "User-Agent Header";
    public static final String SOCKET_TIMEOUT = "Socket Timeout";
    public static final String MAX_RESPONSE_SIZE = "Max response size";
    public static final String ENCODED_URLS = "Pre-encoded Endpoints";
    private SimpleForm httpForm;
    private final String title;

    public HttpPrefs(String title) {
        this.title = title;
    }

    public SimpleForm getForm() {
        if (this.httpForm == null) {
            this.httpForm = new SimpleForm();
            this.httpForm.addSpace(5);
            this.httpForm.appendTextField(USER_AGENT_HEADER, "User-Agent HTTP header to send, blank will send default");
            this.httpForm.appendCheckBox(CLOSE_CONNECTIONS_AFTER_REQUEST, "Closes the HTTP connection after each SOAP request", true);
            this.httpForm.appendCheckBox(AUTHENTICATE_PREEMPTIVELY, "Adds authentication information to outgoing request", true);
            this.httpForm.appendCheckBox(INCLUDE_REQUEST_IN_TIME_TAKEN, "Includes the time it took to write the request in time-taken", true);
            this.httpForm.appendCheckBox(INCLUDE_RESPONSE_IN_TIME_TAKEN, "Includes the time it took to read the entire response in time-taken", true);
            this.httpForm.appendCheckBox(ENCODED_URLS, "Do not URL-escape service endpoints", true);
            this.httpForm.appendTextField(SOCKET_TIMEOUT, "Socket timeout in milliseconds");
            this.httpForm.appendTextField(MAX_RESPONSE_SIZE, "Maximum size to read from response (0 = no limit)");
            this.httpForm.addSpace(5);
        }
        return this.httpForm;
    }

    public void getFormValues(Settings settings) {
        StringToStringMap httpValues = new StringToStringMap();
        this.httpForm.getValues(httpValues);
        this.storeValues(httpValues, settings);
    }

    public void storeValues(StringToStringMap httpValues, Settings settings) {
        settings.setString(HttpSettings.USER_AGENT, (String)httpValues.get(USER_AGENT_HEADER));
        settings.setString(HttpSettings.CLOSE_CONNECTIONS, (String)httpValues.get(CLOSE_CONNECTIONS_AFTER_REQUEST));
        settings.setString(HttpSettings.AUTHENTICATE_PREEMPTIVELY, (String)httpValues.get(AUTHENTICATE_PREEMPTIVELY));
        settings.setString(HttpSettings.SOCKET_TIMEOUT, (String)httpValues.get(SOCKET_TIMEOUT));
        settings.setString(HttpSettings.ENCODED_URLS, (String)httpValues.get(ENCODED_URLS));
        settings.setString(HttpSettings.MAX_RESPONSE_SIZE, (String)httpValues.get(MAX_RESPONSE_SIZE));
        settings.setString(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, (String)httpValues.get(INCLUDE_REQUEST_IN_TIME_TAKEN));
        settings.setString(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, (String)httpValues.get(INCLUDE_RESPONSE_IN_TIME_TAKEN));
    }

    public void setFormValues(Settings settings) {
        this.getForm().setValues(this.getValues(settings));
    }

    public StringToStringMap getValues(Settings settings) {
        StringToStringMap httpValues = new StringToStringMap();
        httpValues.put(USER_AGENT_HEADER, settings.getString(HttpSettings.USER_AGENT, null));
        httpValues.put(CLOSE_CONNECTIONS_AFTER_REQUEST, settings.getString(HttpSettings.CLOSE_CONNECTIONS, null));
        httpValues.put(AUTHENTICATE_PREEMPTIVELY, settings.getString(HttpSettings.AUTHENTICATE_PREEMPTIVELY, null));
        httpValues.put(INCLUDE_REQUEST_IN_TIME_TAKEN, settings.getString(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, null));
        httpValues.put(INCLUDE_RESPONSE_IN_TIME_TAKEN, settings.getString(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, null));
        httpValues.put(SOCKET_TIMEOUT, settings.getString(HttpSettings.SOCKET_TIMEOUT, null));
        httpValues.put(ENCODED_URLS, settings.getString(HttpSettings.ENCODED_URLS, null));
        httpValues.put(MAX_RESPONSE_SIZE, settings.getString(HttpSettings.MAX_RESPONSE_SIZE, "0"));
        return httpValues;
    }

    public String getTitle() {
        return this.title;
    }
}

