/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.jgroups.ReceiverAdapter;

public class RoundTripUdp
extends ReceiverAdapter {
    DatagramSocket sock;
    InetAddress host;
    int port = 7500;
    int num = 1000;
    int msg_size = 10;
    boolean server = false;
    final byte[] RSP_BUF = new byte[]{1};
    int num_responses = 0;

    private void start(boolean server, int num, int msg_size, InetAddress host, int port) throws IOException {
        this.server = server;
        this.num = num;
        this.msg_size = msg_size;
        this.host = host;
        this.port = port;
        if (server) {
            this.sock = new DatagramSocket(port, host);
            System.out.println("server started (ctrl-c to kill)");
            while (true) {
                byte[] buf = new byte[65000];
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                this.sock.receive(packet);
                packet = new DatagramPacket(this.RSP_BUF, 0, this.RSP_BUF.length, packet.getAddress(), packet.getPort());
                this.sock.send(packet);
            }
        }
        this.sock = new DatagramSocket();
        System.out.println("sending " + num + " requests");
        this.sendRequests();
        this.sock.close();
    }

    private void sendRequests() {
        int i;
        byte[] buf = new byte[this.msg_size];
        int print = this.num / 10;
        this.num_responses = 0;
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < this.num; ++i) {
            DatagramPacket packet = new DatagramPacket(buf, 0, buf.length, this.host, this.port);
            try {
                this.sock.send(packet);
                byte[] response = new byte[1];
                DatagramPacket rsp_packet = new DatagramPacket(response, 0, response.length);
                this.sock.receive(rsp_packet);
                ++this.num_responses;
                if (this.num_responses >= this.num) {
                    System.out.println("received all responses (" + this.num_responses + ")");
                    break;
                }
                if (this.num_responses % print != 0) continue;
                System.out.println("- received " + this.num_responses);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long stop = System.currentTimeMillis();
        long total = stop - start;
        double requests_per_sec = (double)this.num / ((double)total / 1000.0);
        double ms_per_req = (double)total / (double)this.num;
        System.out.println("Took " + total + "ms for " + this.num + " requests: " + requests_per_sec + " requests/sec, " + ms_per_req + " ms/request");
    }

    public static void main(String[] args) throws IOException {
        boolean server = false;
        int num = 100;
        int msg_size = 10;
        InetAddress host = null;
        int port = 7500;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-server")) {
                server = true;
                continue;
            }
            if (args[i].equals("-size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-host")) {
                host = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            RoundTripUdp.help();
            return;
        }
        if (host == null) {
            host = InetAddress.getLocalHost();
        }
        new RoundTripUdp().start(server, num, msg_size, host, port);
    }

    private static void help() {
        System.out.println("RoundTrip [-server] [-num <number of messages>] [-size <size of each message (in bytes)>] [-host <host>] [-port <port>]");
    }
}

