/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.TimeScheduler;

public class CoordGmsImpl
extends GmsImpl {
    private boolean merging = false;
    private final MergeTask merge_task = new MergeTask();
    private final Vector merge_rsps = new Vector(11);
    private ViewId merge_id = null;
    private Address merge_leader = null;
    private MergeCanceller merge_canceller = null;
    private final Object merge_canceller_mutex = new Object();
    private final Long MAX_SUSPEND_TIMEOUT = new Long(30000L);

    public CoordGmsImpl(GMS g) {
        super(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMergeId(ViewId merge_id) {
        this.merge_id = merge_id;
        Object object = this.merge_canceller_mutex;
        synchronized (object) {
            if (this.merge_id != null) {
                this.stopMergeCanceller();
                this.merge_canceller = new MergeCanceller(this.merge_id, this.gms.merge_timeout);
                this.gms.timer.add(this.merge_canceller);
            } else {
                this.stopMergeCanceller();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMergeCanceller() {
        Object object = this.merge_canceller_mutex;
        synchronized (object) {
            if (this.merge_canceller != null) {
                this.merge_canceller.cancel();
                this.merge_canceller = null;
            }
        }
    }

    public void init() throws Exception {
        super.init();
        this.cancelMerge();
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    public void leave(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"member's address is null !");
            }
            return;
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.gms.getViewHandler().add(new GMS.Request(2, mbr, false, null));
        this.gms.getViewHandler().stop(true);
        this.gms.getViewHandler().waitUntilCompleted(this.gms.leave_timeout);
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
    }

    public void handleLeaveResponse() {
    }

    public void suspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"I am the coord and I'm being am suspected -- will probably leave shortly");
            }
            return;
        }
        LinkedHashSet emptyVector = new LinkedHashSet(0);
        LinkedHashSet<Address> suspected = new LinkedHashSet<Address>(1);
        suspected.add(mbr);
        this.handleMembershipChange(emptyVector, emptyVector, suspected);
    }

    public void unsuspect(Address mbr) {
    }

    public void merge(Vector other_coords) {
        if (this.merging) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("merge already in progress, discarded MERGE event (I am " + this.gms.local_addr + ")"));
            }
            return;
        }
        this.merge_leader = null;
        if (other_coords == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"list of other coordinators is null. Will not start merge.");
            }
            return;
        }
        if (other_coords.size() <= 1) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("number of coordinators found is " + other_coords.size() + "; will not perform merge"));
            }
            return;
        }
        Membership tmp = new Membership(other_coords);
        tmp.sort();
        this.merge_leader = (Address)tmp.elementAt(0);
        if (this.merge_leader.equals(this.gms.local_addr) || this.gms.merge_leader) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("I (" + this.gms.local_addr + ") will be the leader. Starting the merge task"));
            }
            this.startMergeTask(other_coords);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("I (" + this.gms.local_addr + ") am not the merge leader, " + "waiting for merge leader (" + this.merge_leader + ")to initiate merge"));
        }
    }

    public void handleMergeRequest(Address sender, ViewId merge_id) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender == null; cannot send back a response");
            }
            return;
        }
        if (this.merging) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge already in progress");
            }
            this.sendMergeRejectedResponse(sender, merge_id);
            return;
        }
        this.merging = true;
        this.gms.getViewHandler().suspend(merge_id);
        this.setMergeId(merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sender=" + sender + ", merge_id=" + merge_id));
        }
        Digest digest = this.gms.getDigest();
        View view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
        this.gms.passDown(new Event(67, sender));
        this.sendMergeResponse(sender, view, digest);
    }

    private MergeData getMergeResponse(Address sender, ViewId merge_id) {
        MergeData retval;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender == null; cannot send back a response");
            }
            return null;
        }
        if (this.merging) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge already in progress");
            }
            MergeData retval2 = new MergeData(sender, null, null);
            retval2.merge_rejected = true;
            return retval2;
        }
        this.merging = true;
        this.setMergeId(merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sender=" + sender + ", merge_id=" + merge_id));
        }
        try {
            Digest digest = this.gms.getDigest();
            View view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
            retval = new MergeData(sender, view, digest);
            retval.view = view;
            retval.digest = digest;
        }
        catch (NullPointerException null_ex) {
            return null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMergeResponse(MergeData data, ViewId merge_id) {
        if (data == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge data is null");
            }
            return;
        }
        if (merge_id == null || this.merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("merge_id (" + merge_id + ") or this.merge_id (" + this.merge_id + ") is null (sender=" + data.getSender() + ")."));
            }
            return;
        }
        if (!this.merge_id.equals(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ')'));
            }
            return;
        }
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            if (!this.merge_rsps.contains(data)) {
                this.merge_rsps.addElement(data);
                this.merge_rsps.notifyAll();
            }
        }
    }

    public void handleMergeView(MergeData data, ViewId merge_id) {
        if (merge_id == null || this.merge_id == null || !this.merge_id.equals(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge_ids don't match (or are null); merge view discarded");
            }
            return;
        }
        Vector my_members = this.gms.view != null ? this.gms.view.getMembers() : null;
        GMS.Request req = new GMS.Request(5);
        req.view = data.view;
        req.digest = data.digest;
        req.target_members = my_members;
        this.gms.getViewHandler().add(req, true, true);
        this.merging = false;
    }

    public void handleMergeCancelled(ViewId merge_id) {
        if (merge_id != null && this.merge_id != null && this.merge_id.equals(merge_id)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("merge was cancelled (merge_id=" + merge_id + ", local_addr=" + this.gms.local_addr + ")"));
            }
            this.setMergeId(null);
            this.merge_leader = null;
            this.merging = false;
            this.gms.getViewHandler().resume(merge_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelMerge() {
        ViewId tmp = this.merge_id;
        if (this.merge_id != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("cancelling merge (merge_id=" + this.merge_id + ')'));
        }
        this.setMergeId(null);
        this.merge_leader = null;
        this.stopMergeTask();
        this.merging = false;
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.clear();
        }
        this.gms.getViewHandler().resume(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMembershipChange(Collection new_mbrs, Collection leaving_mbrs, Collection suspected_mbrs) {
        if (new_mbrs == null) {
            new_mbrs = new LinkedHashSet(0);
        }
        if (suspected_mbrs == null) {
            suspected_mbrs = new LinkedHashSet(0);
        }
        if (leaving_mbrs == null) {
            leaving_mbrs = new LinkedHashSet(0);
        }
        boolean joining_mbrs = !new_mbrs.isEmpty();
        new_mbrs.remove(this.gms.local_addr);
        if (this.gms.view_id == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("gms.view_id is null, I'm not the coordinator anymore (leaving=" + this.leaving + "); the new coordinator will handle the leave request"));
            }
            return;
        }
        Vector current_members = this.gms.members.getMembers();
        leaving_mbrs.retainAll(current_members);
        if (suspected_mbrs.remove(this.gms.local_addr) && this.log.isWarnEnabled()) {
            this.log.warn((Object)"I am the coord and I'm being suspected -- will probably leave shortly");
        }
        suspected_mbrs.retainAll(current_members);
        Iterator it = new_mbrs.iterator();
        while (it.hasNext()) {
            Address mbr = (Address)it.next();
            if (!this.gms.members.contains(mbr)) continue;
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)(mbr + " already present; returning existing view " + this.gms.view));
            }
            JoinRsp join_rsp = new JoinRsp(new View(this.gms.view_id, this.gms.members.getMembers()), this.gms.getDigest());
            this.sendJoinResponse(join_rsp, mbr);
            it.remove();
        }
        if (new_mbrs.isEmpty() && leaving_mbrs.isEmpty() && suspected_mbrs.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"found no members to add or remove, will not create new view");
            }
            return;
        }
        JoinRsp join_rsp = null;
        View new_view = this.gms.getNextView(new_mbrs, leaving_mbrs, suspected_mbrs);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("new=" + new_mbrs + ", suspected=" + suspected_mbrs + ", leaving=" + leaving_mbrs + ", new view: " + new_view));
        }
        try {
            Vector tmp_mbrs;
            if (joining_mbrs) {
                this.gms.passDown(new Event(65, this.MAX_SUSPEND_TIMEOUT));
                Digest d = null;
                Digest tmp = this.gms.getDigest();
                if (tmp == null) {
                    this.log.error((Object)"received null digest from GET_DIGEST: will cause JOIN to fail");
                } else {
                    d = new Digest(tmp.size() + new_mbrs.size());
                    d.add(tmp);
                    Iterator i = new_mbrs.iterator();
                    while (i.hasNext()) {
                        d.add((Address)i.next(), 0L, 0L);
                    }
                }
                join_rsp = new JoinRsp(new_view, d);
            }
            this.sendLeaveResponses(leaving_mbrs);
            if (new_view != null) {
                this.gms.passDown(new Event(15, new_view));
            }
            Vector vector = tmp_mbrs = new_view != null ? new Vector(new_view.getMembers()) : null;
            if (this.gms.use_flush) {
                boolean successfulFlush = this.gms.startFlush(new_view, 3);
                if (successfulFlush) {
                    this.log.info((Object)("Successful GMS flush by coordinator at " + this.gms.getLocalAddress()));
                }
                this.sendJoinResponses(join_rsp, new_mbrs);
                this.gms.castViewChangeWithDest(new_view, null, tmp_mbrs);
            } else {
                if (tmp_mbrs != null) {
                    tmp_mbrs.removeAll(new_mbrs);
                }
                this.gms.castViewChangeWithDest(new_view, null, tmp_mbrs);
                this.sendJoinResponses(join_rsp, new_mbrs);
            }
        }
        finally {
            if (joining_mbrs) {
                this.gms.passDown(new Event(66));
            }
            if (this.gms.use_flush) {
                this.gms.stopFlush(new_view);
            }
            if (this.leaving) {
                this.gms.passUp(new Event(5));
                this.gms.initState();
            }
        }
    }

    public void handleViewChange(View new_view, Digest digest) {
        Vector mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            if (digest != null) {
                this.log.debug((Object)("view=" + new_view + ", digest=" + digest));
            } else {
                this.log.debug((Object)("view=" + new_view));
            }
        }
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    public void handleExit() {
        this.cancelMerge();
    }

    public void stop() {
        super.stop();
        this.stopMergeTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMergeTask(Vector coords) {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.start(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMergeTask() {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.stop();
        }
    }

    private void sendJoinResponses(JoinRsp rsp, Collection c) {
        if (c != null && rsp != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.sendJoinResponse(rsp, (Address)it.next());
            }
        }
    }

    private void sendJoinResponse(JoinRsp rsp, Address dest) {
        Message m = new Message(dest, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(2, rsp);
        m.putHeader(this.gms.getName(), hdr);
        this.gms.passDown(new Event(1, m));
    }

    private void sendLeaveResponses(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Message msg = new Message((Address)i.next(), null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(4);
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.passDown(new Event(1, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMergeDataFromSubgroupCoordinators(Vector coords, long timeout) {
        if (coords == null || coords.size() <= 1) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"coords == null or size <= 1");
            }
            return;
        }
        long start = System.currentTimeMillis();
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.removeAllElements();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sending MERGE_REQ to " + coords));
            }
            for (int i = 0; i < coords.size(); ++i) {
                Address coord = (Address)coords.elementAt(i);
                if (this.gms.local_addr != null && this.gms.local_addr.equals(coord)) {
                    MergeData tmp = this.getMergeResponse(this.gms.local_addr, this.merge_id);
                    if (tmp == null) continue;
                    this.merge_rsps.add(tmp);
                    continue;
                }
                this.gms.passDown(new Event(67, coord));
                Message msg = new Message(coord, null, null);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6);
                hdr.mbr = this.gms.local_addr;
                hdr.merge_id = this.merge_id;
                msg.putHeader(this.gms.getName(), hdr);
                this.gms.passDown(new Event(1, msg));
            }
            int num_rsps_expected = coords.size();
            long curr_time = System.currentTimeMillis();
            long end_time = curr_time + timeout;
            while (end_time > curr_time) {
                long time_to_wait = end_time - curr_time;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("waiting " + time_to_wait + " msecs for merge responses"));
                }
                if (this.merge_rsps.size() < num_rsps_expected) {
                    try {
                        this.merge_rsps.wait(time_to_wait);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("num_rsps_expected=" + num_rsps_expected + ", actual responses=" + this.merge_rsps.size()));
                }
                if (this.merge_rsps.size() >= num_rsps_expected) break;
                curr_time = System.currentTimeMillis();
            }
            long stop = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("collected " + this.merge_rsps.size() + " merge response(s) in " + (stop - start) + "ms"));
            }
        }
    }

    private ViewId generateMergeId() {
        return new ViewId(this.gms.local_addr, System.currentTimeMillis());
    }

    private MergeData consolidateMergeData(Vector v) {
        Digest new_digest;
        Address new_coord;
        long logical_time = 0L;
        Membership new_mbrs = new Membership();
        Vector<Object> subgroups = new Vector<Object>(11);
        for (int i = 0; i < v.size(); ++i) {
            View tmp_view;
            MergeData tmp_data = (MergeData)v.elementAt(i);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("merge data is " + tmp_data));
            }
            if ((tmp_view = tmp_data.getView()) == null) continue;
            ViewId tmp_vid = tmp_view.getVid();
            if (tmp_vid != null) {
                logical_time = Math.max(logical_time, tmp_vid.getId());
            }
            new_mbrs.add(tmp_view.getMembers());
            subgroups.addElement(tmp_view.clone());
        }
        new_mbrs.sort();
        int num_mbrs = new_mbrs.size();
        Address address = new_coord = num_mbrs > 0 ? (Address)new_mbrs.elementAt(0) : null;
        if (new_coord == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"new_coord == null");
            }
            return null;
        }
        ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
        MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("new merged view will be " + new_view));
        }
        if ((new_digest = this.consolidateDigests(v, num_mbrs)) == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest could not be consolidated");
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("consolidated digest=" + new_digest));
        }
        MergeData ret = new MergeData(this.gms.local_addr, new_view, new_digest);
        return ret;
    }

    private Digest consolidateDigests(Vector v, int num_mbrs) {
        Digest retval = new Digest(num_mbrs);
        for (int i = 0; i < v.size(); ++i) {
            MergeData data = (MergeData)v.elementAt(i);
            Digest tmp_digest = data.getDigest();
            if (tmp_digest == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"tmp_digest == null; skipping");
                continue;
            }
            retval.merge(tmp_digest);
        }
        return retval;
    }

    private void sendMergeView(Vector coords, MergeData combined_merge_data) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View v = combined_merge_data.view;
        Digest d = combined_merge_data.digest;
        if (v == null || d == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"view or digest is null, cannot send consolidated merge view/digest");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("sending merge view " + v.getVid() + " to coordinators " + coords));
        }
        for (int i = 0; i < coords.size(); ++i) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = v;
            hdr.my_digest = d;
            hdr.merge_id = this.merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.passDown(new Event(1, msg));
        }
    }

    private void sendMergeResponse(Address sender, View view, Digest digest) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = this.merge_id;
        hdr.view = view;
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("response=" + hdr));
        }
        this.gms.passDown(new Event(1, msg));
    }

    private void sendMergeCancelledMessage(Vector coords, ViewId merge_id) {
        if (coords == null || merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"coords or merge_id == null");
            }
            return;
        }
        for (int i = 0; i < coords.size(); ++i) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.passDown(new Event(1, msg));
        }
    }

    private void removeRejectedMergeRequests(Vector coords) {
        Iterator it = this.merge_rsps.iterator();
        while (it.hasNext()) {
            MergeData data = (MergeData)it.next();
            if (!data.merge_rejected) continue;
            if (data.getSender() != null && coords != null) {
                coords.removeElement(data.getSender());
            }
            it.remove();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("removed element " + data));
        }
    }

    private class MergeCanceller
    implements TimeScheduler.Task {
        private Object my_merge_id = null;
        private long timeout;
        private boolean cancelled = false;

        MergeCanceller(Object my_merge_id, long timeout) {
            this.my_merge_id = my_merge_id;
            this.timeout = timeout;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public long nextInterval() {
            return this.timeout;
        }

        public void run() {
            if (CoordGmsImpl.this.merge_id != null && this.my_merge_id.equals(CoordGmsImpl.this.merge_id)) {
                if (CoordGmsImpl.this.log.isTraceEnabled()) {
                    CoordGmsImpl.this.log.trace((Object)("cancelling merge due to timer timeout (" + this.timeout + " ms)"));
                }
                CoordGmsImpl.this.cancelMerge();
                this.cancelled = true;
            } else if (CoordGmsImpl.this.log.isTraceEnabled()) {
                CoordGmsImpl.this.log.trace((Object)("timer kicked in after " + this.timeout + " ms, but no (or different) merge was in progress: " + "merge_id=" + CoordGmsImpl.this.merge_id + ", my_merge_id=" + this.my_merge_id));
            }
        }
    }

    private class MergeTask
    implements Runnable {
        Thread t = null;
        Vector coords = null;

        private MergeTask() {
        }

        public void start(Vector coords) {
            if (this.t == null || !this.t.isAlive()) {
                this.coords = (Vector)(coords != null ? coords.clone() : null);
                this.t = new Thread((Runnable)this, "MergeTask");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            Thread tmp = this.t;
            if (this.isRunning()) {
                this.t = null;
                tmp.interrupt();
            }
            this.t = null;
            this.coords = null;
        }

        public boolean isRunning() {
            return this.t != null && this.t.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (CoordGmsImpl.this.merging) {
                if (CoordGmsImpl.this.log.isWarnEnabled()) {
                    CoordGmsImpl.this.log.warn((Object)"merge is already in progress, terminating");
                }
                return;
            }
            if (CoordGmsImpl.this.log.isDebugEnabled()) {
                CoordGmsImpl.this.log.debug((Object)("merge task started, coordinators are " + this.coords));
            }
            try {
                CoordGmsImpl.this.setMergeId(CoordGmsImpl.this.generateMergeId());
                CoordGmsImpl.this.getMergeDataFromSubgroupCoordinators(this.coords, CoordGmsImpl.this.gms.merge_timeout);
                CoordGmsImpl.this.removeRejectedMergeRequests(this.coords);
                if (CoordGmsImpl.this.merge_rsps.size() <= 1) {
                    if (CoordGmsImpl.this.log.isWarnEnabled()) {
                        CoordGmsImpl.this.log.warn((Object)("merge responses from subgroup coordinators <= 1 (" + CoordGmsImpl.this.merge_rsps + "). Cancelling merge"));
                    }
                    CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                    return;
                }
                MergeData combined_merge_data = CoordGmsImpl.this.consolidateMergeData(CoordGmsImpl.this.merge_rsps);
                if (combined_merge_data == null) {
                    if (CoordGmsImpl.this.log.isErrorEnabled()) {
                        CoordGmsImpl.this.log.error((Object)"combined_merge_data == null");
                    }
                    CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                    return;
                }
                CoordGmsImpl.this.gms.getViewHandler().suspend(CoordGmsImpl.this.merge_id);
                CoordGmsImpl.this.sendMergeView(this.coords, combined_merge_data);
            }
            catch (Throwable ex) {
                if (CoordGmsImpl.this.log.isErrorEnabled()) {
                    CoordGmsImpl.this.log.error((Object)"exception while merging", ex);
                }
            }
            finally {
                CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                CoordGmsImpl.this.stopMergeCanceller();
                CoordGmsImpl.this.merging = false;
                CoordGmsImpl.this.merge_leader = null;
                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                    CoordGmsImpl.this.log.debug((Object)"merge task terminated");
                }
                this.t = null;
            }
        }
    }
}

