/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.stack.IpAddress;

public class TCP_NIO
extends BasicTCP
implements BasicConnectionTable.Receiver {
    private int m_reader_threads = 8;
    private int m_writer_threads = 8;
    private int m_processor_threads = 10;
    private int m_processor_minThreads = 10;
    private int m_processor_maxThreads = 10;
    private int m_processor_queueSize = 100;
    private int m_processor_keepAliveTime = -1;
    private ConnectionTableNIO ct;

    protected ConnectionTableNIO getConnectionTable(long ri, long cet, InetAddress b_addr, InetAddress bc_addr, int s_port, int e_port) throws Exception {
        ConnectionTableNIO retval = null;
        if (ri == 0L && cet == 0L) {
            retval = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port, false);
        } else {
            if (ri == 0L) {
                ri = 5000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("reaper_interval was 0, set it to " + ri));
                }
            }
            if (cet == 0L) {
                cet = 300000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("conn_expire_time was 0, set it to " + cet));
                }
            }
            retval = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port, ri, cet, false);
        }
        retval.setProcessorMaxThreads(this.getProcessorMaxThreads());
        retval.setProcessorQueueSize(this.getProcessorQueueSize());
        retval.setProcessorMinThreads(this.getProcessorMinThreads());
        retval.setProcessorKeepAliveTime(this.getProcessorKeepAliveTime());
        retval.setProcessorThreads(this.getProcessorThreads());
        retval.start();
        return retval;
    }

    public String printConnections() {
        return this.ct.toString();
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        this.ct.send(dest, data, offset, length);
    }

    public void start() throws Exception {
        this.ct = this.getConnectionTable(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.start_port, this.end_port);
        this.ct.setUseSendQueues(this.use_send_queues);
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.ct.setTcpNodelay(this.tcp_nodelay);
        this.ct.setLinger(this.linger);
        this.local_addr = this.ct.getLocalAddress();
        if (this.additional_data != null && this.local_addr instanceof IpAddress) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        super.start();
    }

    public void retainAll(Collection members) {
        this.ct.retainAll(members);
    }

    public void stop() {
        this.ct.stop();
        super.stop();
    }

    public String getName() {
        return "TCP_NIO";
    }

    public int getReaderThreads() {
        return this.m_reader_threads;
    }

    public int getWriterThreads() {
        return this.m_writer_threads;
    }

    public int getProcessorThreads() {
        return this.m_processor_threads;
    }

    public int getProcessorMinThreads() {
        return this.m_processor_minThreads;
    }

    public int getProcessorMaxThreads() {
        return this.m_processor_maxThreads;
    }

    public int getProcessorQueueSize() {
        return this.m_processor_queueSize;
    }

    public int getProcessorKeepAliveTime() {
        return this.m_processor_keepAliveTime;
    }

    public int getOpenConnections() {
        return this.ct.getNumConnections();
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("reader_threads");
        if (str != null) {
            this.m_reader_threads = Integer.parseInt(str);
            props.remove("reader_threads");
        }
        if ((str = props.getProperty("writer_threads")) != null) {
            this.m_writer_threads = Integer.parseInt(str);
            props.remove("writer_threads");
        }
        if ((str = props.getProperty("processor_threads")) != null) {
            this.m_processor_threads = Integer.parseInt(str);
            props.remove("processor_threads");
        }
        if ((str = props.getProperty("processor_minThreads")) != null) {
            this.m_processor_minThreads = Integer.parseInt(str);
            props.remove("processor_minThreads");
        }
        if ((str = props.getProperty("processor_maxThreads")) != null) {
            this.m_processor_maxThreads = Integer.parseInt(str);
            props.remove("processor_maxThreads");
        }
        if ((str = props.getProperty("processor_queueSize")) != null) {
            this.m_processor_queueSize = Integer.parseInt(str);
            props.remove("processor_queueSize");
        }
        if ((str = props.getProperty("processor_keepAliveTime")) != null) {
            this.m_processor_keepAliveTime = Integer.parseInt(str);
            props.remove("processor_keepAliveTime");
        }
        return super.setProperties(props);
    }
}

