/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.stack.AckMcastSenderWindow;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class SMACK
extends Protocol
implements AckMcastSenderWindow.RetransmitCommand {
    long[] timeout = new long[]{1000L, 2000L, 3000L};
    int max_xmits = 10;
    final Vector members = new Vector();
    AckMcastSenderWindow sender_win = null;
    final HashMap receivers = new HashMap();
    final HashMap xmit_table = new HashMap();
    Address local_addr = null;
    long seqno = 1L;
    long vid = 1L;
    boolean print_local_addr = true;
    static final String name = "SMACK";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("print_local_addr");
        if (str != null) {
            this.print_local_addr = Boolean.valueOf(str);
            props.remove("print_local_addr");
        }
        if ((str = props.getProperty("timeout")) != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("timeout");
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
        }
        if ((str = props.getProperty("max_xmits")) != null) {
            this.max_xmits = Integer.parseInt(str);
            props.remove("max_xmits");
        }
        if (props.size() > 0) {
            this.log.error((Object)("SMACK.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.sender_win != null) {
            this.sender_win.stop();
            this.sender_win = null;
        }
        Iterator it = this.receivers.values().iterator();
        while (it.hasNext()) {
            AckReceiverWindow win = (AckReceiverWindow)it.next();
            win.reset();
        }
        this.receivers.clear();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.addMember(this.local_addr);
                if (!this.print_local_addr) break;
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
                break;
            }
            case 3: {
                this.passUp(evt);
                this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, this.timeout);
                Message join_msg = new Message();
                join_msg.putHeader(name, new SmackHeader(3, -1L));
                this.passDown(new Event(1, join_msg));
                return;
            }
            case 9: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("removing suspected member " + evt.getArg()));
                }
                this.removeMember((Address)evt.getArg());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null) break;
                Address sender = msg.getSrc();
                SmackHeader hdr = (SmackHeader)msg.removeHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message tmp_msg;
                        AckReceiverWindow win;
                        Message ack_msg = new Message(sender);
                        ack_msg.putHeader(name, new SmackHeader(2, hdr.seqno));
                        this.passDown(new Event(1, ack_msg));
                        Long tmp_seqno = new Long(hdr.seqno);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("received #" + tmp_seqno + " from " + sender));
                        }
                        if ((win = (AckReceiverWindow)this.receivers.get(sender)) == null) {
                            this.addMember(sender);
                            win = new AckReceiverWindow(hdr.seqno);
                            this.receivers.put(sender, win);
                        }
                        win.add(hdr.seqno, msg);
                        while ((tmp_msg = win.remove()) != null) {
                            this.passUp(new Event(1, tmp_msg));
                        }
                        return;
                    }
                    case 2: {
                        this.addMember(msg.getSrc());
                        this.sender_win.ack(hdr.seqno, msg.getSrc());
                        this.sender_win.clearStableMessages();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("received ack for #" + hdr.seqno + " from " + msg.getSrc()));
                        }
                        return;
                    }
                    case 3: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("received join announcement by " + msg.getSrc()));
                        }
                        if (!this.containsMember(sender)) {
                            Message join_rsp = new Message(sender);
                            join_rsp.putHeader(name, new SmackHeader(3, -1L));
                            this.passDown(new Event(1, join_rsp));
                        }
                        this.addMember(sender);
                        return;
                    }
                    case 4: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("received leave announcement by " + msg.getSrc()));
                        }
                        this.removeMember(sender);
                        return;
                    }
                }
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)("detected SmackHeader with invalid type: " + hdr));
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 4: {
                Message leave_msg = new Message();
                leave_msg.putHeader(name, new SmackHeader(4, -1L));
                this.passDown(new Event(1, leave_msg));
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null || msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                msg.putHeader(name, new SmackHeader(1, this.seqno));
                this.sender_win.add(this.seqno, msg, (Vector)this.members.clone());
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("sending mcast #" + this.seqno));
                }
                ++this.seqno;
            }
        }
        this.passDown(evt);
    }

    public void retransmit(long seqno, Message msg, Address dest) {
        msg.setDest(dest);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(seqno + ", msg=" + msg));
        }
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(Address mbr) {
        Vector vector = this.members;
        synchronized (vector) {
            if (mbr != null && !this.members.contains(mbr)) {
                this.members.addElement(mbr);
                Object tmp = this.members.clone();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("added " + mbr + ", members=" + tmp));
                }
                View new_view = new View(new ViewId(this.local_addr, this.vid++), (Vector)tmp);
                this.passUp(new Event(6, new_view));
                this.passDown(new Event(6, new_view));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMember(Address mbr) {
        Vector vector = this.members;
        synchronized (vector) {
            if (mbr != null) {
                this.members.removeElement(mbr);
                Object tmp = this.members.clone();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("removed " + mbr + ", members=" + tmp));
                }
                View new_view = new View(new ViewId(this.local_addr, this.vid++), (Vector)tmp);
                this.passUp(new Event(6, new_view));
                this.passDown(new Event(6, new_view));
                if (this.sender_win != null) {
                    this.sender_win.remove(mbr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsMember(Address mbr) {
        Vector vector = this.members;
        synchronized (vector) {
            return mbr != null && this.members.contains(mbr);
        }
    }

    public static class SmackHeader
    extends Header
    implements Streamable {
        public static final byte MCAST = 1;
        public static final byte ACK = 2;
        public static final byte JOIN_ANNOUNCEMENT = 3;
        public static final byte LEAVE_ANNOUNCEMENT = 4;
        byte type = 0;
        long seqno = -1L;

        public SmackHeader() {
        }

        public SmackHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }

        public long size() {
            return 9L;
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "MCAST";
                }
                case 2: {
                    return "ACK";
                }
                case 3: {
                    return "JOIN_ANNOUNCEMENT";
                }
                case 4: {
                    return "LEAVE_ANNOUNCEMENT";
                }
            }
            return "<unknown>";
        }
    }
}

