/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Marshaller;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Message
implements Externalizable,
Streamable {
    protected Address dest_addr = null;
    protected Address src_addr = null;
    private byte[] buf = null;
    protected transient int offset = 0;
    protected transient int length = 0;
    protected Map headers;
    protected static final Log log;
    private static final long serialVersionUID = 7966206671974139740L;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    static final byte IPADDR_DEST = 16;
    static final byte IPADDR_SRC = 32;
    static final byte SRC_HOST_NULL = 64;
    static final HashSet nonStreamableHeaders;
    private static final Map canonicalAddresses;
    private static final boolean DISABLE_CANONICALIZATION;

    public Message(Address dest) {
        this.dest_addr = dest;
        this.headers = Message.createHeaders(7);
    }

    public Message(Address dest, Address src, byte[] buf) {
        this(dest);
        this.src_addr = src;
        this.setBuffer(buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this(dest);
        this.src_addr = src;
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, Address src, Serializable obj) {
        this(dest);
        this.src_addr = src;
        this.setObject(obj);
    }

    public Message() {
        this.headers = Message.createHeaders(7);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(7);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = DISABLE_CANONICALIZATION ? new_dest : Message.canonicalAddress(new_dest);
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = DISABLE_CANONICALIZATION ? new_src : Message.canonicalAddress(new_src);
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public final byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public final void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            length = 0;
            offset = 0;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public final void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            byte[] tmp = Util.objectToByteBuffer(obj);
            this.setBuffer(tmp);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public final Object getObject() {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public void reset() {
        this.src_addr = null;
        this.dest_addr = null;
        this.setBuffer(null);
        this.headers.clear();
    }

    public void putHeader(String key, Header hdr) {
        this.headers.put(key, hdr);
    }

    public Header removeHeader(String key) {
        return (Header)this.headers.remove(key);
    }

    public void removeHeaders() {
        this.headers.clear();
    }

    public Header getHeader(String key) {
        return (Header)this.headers.get(key);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = Message.createHeaders(this.headers);
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr);
    }

    public String toString() {
        int size;
        StringBuffer ret = new StringBuffer(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        if (this.headers != null && (size = this.headers.size()) > 0) {
            ret.append(" (").append(size).append(" headers)");
        }
        ret.append(", size = ");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = 1 + this.length + (this.buf != null ? 4 : 0);
        if (this.src_addr != null) {
            retval += (long)this.src_addr.size();
        }
        retval += 2L;
        Iterator it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            retval += (long)(key.length() + 2);
            Header hdr = (Header)entry.getValue();
            retval += 5L;
            retval += hdr.size();
        }
        return retval;
    }

    public String printObjectHeaders() {
        StringBuffer sb = new StringBuffer();
        if (this.headers != null) {
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            }
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dest_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.dest_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.src_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.src_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.buf == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int len = this.headers.size();
        out.writeInt(len);
        Iterator it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            out.writeUTF((String)entry.getKey());
            Externalizable hdr = (Externalizable)entry.getValue();
            Marshaller.write(hdr, out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        boolean srcAddressExist;
        boolean destAddressExist = in.readBoolean();
        if (destAddressExist) {
            this.dest_addr = (Address)Marshaller.read(in);
            if (!DISABLE_CANONICALIZATION) {
                this.dest_addr = Message.canonicalAddress(this.dest_addr);
            }
        }
        if (srcAddressExist = in.readBoolean()) {
            this.src_addr = (Address)Marshaller.read(in);
            if (!DISABLE_CANONICALIZATION) {
                this.src_addr = Message.canonicalAddress(this.src_addr);
            }
        }
        if ((i = in.readInt()) != 0) {
            this.buf = new byte[i];
            in.readFully(this.buf);
            this.offset = 0;
            this.length = this.buf.length;
        }
        int len = in.readInt();
        while (len-- > 0) {
            String key = in.readUTF();
            Externalizable value = Marshaller.read(in);
            this.headers.put(key, value);
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        int leading = 0;
        if (this.src_addr != null) {
            leading = (byte)(leading + 2);
            if (this.src_addr instanceof IpAddress) {
                leading = (byte)(leading + 32);
                if (((IpAddress)this.src_addr).getIpAddress() == null) {
                    leading = (byte)(leading + 64);
                }
            }
        }
        if (this.buf != null) {
            leading = (byte)(leading + 4);
        }
        out.write(leading);
        if (this.src_addr != null) {
            if (this.src_addr instanceof IpAddress) {
                this.src_addr.writeTo(out);
            } else {
                Util.writeAddress(this.src_addr, out);
            }
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size();
        out.writeShort(size);
        Iterator it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            out.writeUTF((String)entry.getKey());
            Message.writeHeader((Header)entry.getValue(), out);
        }
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int len;
        byte leading = in.readByte();
        if ((leading & 2) == 2) {
            if ((leading & 0x20) == 32) {
                this.src_addr = new IpAddress();
                this.src_addr.readFrom(in);
            } else {
                this.src_addr = Util.readAddress(in);
            }
            if (!DISABLE_CANONICALIZATION) {
                this.src_addr = Message.canonicalAddress(this.src_addr);
            }
        }
        if ((leading & 4) == 4) {
            len = in.readInt();
            this.buf = new byte[len];
            in.read(this.buf, 0, len);
            this.length = len;
        }
        len = in.readShort();
        this.headers = Message.createHeaders(len);
        for (int i = 0; i < len; ++i) {
            String hdr_name = in.readUTF();
            Header hdr = Message.readHeader(in);
            this.headers.put(hdr_name, hdr);
        }
    }

    private static void writeHeader(Header value, DataOutputStream out) throws IOException {
        ObjectOutputStream oos = null;
        try {
            int magic_number = ClassConfigurator.getInstance(false).getMagicNumber(value.getClass());
            if (magic_number == -1) {
                out.writeBoolean(false);
                String classname = value.getClass().getName();
                out.writeUTF(classname);
            } else {
                out.writeBoolean(true);
                out.writeInt(magic_number);
            }
            if (value instanceof Streamable) {
                ((Streamable)((Object)value)).writeTo(out);
            } else {
                oos = new ObjectOutputStream(out);
                value.writeExternal(oos);
                if (!nonStreamableHeaders.contains(value.getClass())) {
                    nonStreamableHeaders.add(value.getClass());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("encountered non-Streamable header: " + value.getClass()));
                    }
                }
            }
        }
        catch (ChannelException e) {
            IOException io_ex = new IOException("failed writing header");
            io_ex.initCause(e);
            throw io_ex;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    private static Header readHeader(DataInputStream in) throws IOException {
        Header hdr;
        boolean use_magic_number = in.readBoolean();
        ObjectInputStream ois = null;
        try {
            Class clazz;
            if (use_magic_number) {
                int magic_number = in.readInt();
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
                if (clazz == null) {
                    log.error((Object)("magic number " + magic_number + " is not available in magic map"));
                }
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
            }
            if ((hdr = (Header)clazz.newInstance()) instanceof Streamable) {
                ((Streamable)((Object)hdr)).readFrom(in);
            } else {
                ois = new ObjectInputStream(in);
                hdr.readExternal(ois);
            }
        }
        catch (Exception ex) {
            IOException io_ex = new IOException("failed reading header");
            io_ex.initCause(ex);
            throw io_ex;
        }
        return hdr;
    }

    private static Map createHeaders(int size) {
        return size > 0 ? new ConcurrentReaderHashMap(size) : new ConcurrentReaderHashMap();
    }

    private static Map createHeaders(Map m) {
        return new ConcurrentReaderHashMap(m);
    }

    private static Address canonicalAddress(Address nonCanonicalAddress) {
        Address result = null;
        if (nonCanonicalAddress == null) {
            return null;
        }
        try {
            result = (Address)canonicalAddresses.get(nonCanonicalAddress);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (result == null) {
            result = nonCanonicalAddress;
            canonicalAddresses.put(nonCanonicalAddress, result);
        }
        return result;
    }

    static {
        boolean b;
        log = LogFactory.getLog((Class)Message.class);
        nonStreamableHeaders = new HashSet();
        canonicalAddresses = new ConcurrentReaderHashMap();
        try {
            b = Boolean.getBoolean("disable_canonicalization");
        }
        catch (AccessControlException e) {
            b = false;
        }
        DISABLE_CANONICALIZATION = b;
    }
}

