/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.ssl.PEMUtil;

public class PEMItem {
    public static final String DEK_INFO = "dek-info";
    private final byte[] derBytes;
    public final String pemType;
    public final Map properties;
    public final String dekInfo;
    public final byte[] iv;
    public final String cipher;
    public final boolean des2;
    public final String mode;
    public final int keySizeInBits;

    public PEMItem(byte[] derBytes, String type) {
        this(derBytes, type, null);
    }

    public PEMItem(byte[] derBytes, String type, Map properties) {
        boolean doubleDES = false;
        this.derBytes = derBytes;
        this.pemType = type;
        if (properties == null) {
            properties = new TreeMap();
        }
        this.properties = Collections.unmodifiableMap(properties);
        String di = (String)properties.get(DEK_INFO);
        String diCipher = "";
        String diIV = "";
        if (di != null) {
            StringTokenizer st = new StringTokenizer(di, ",");
            if (st.hasMoreTokens()) {
                diCipher = st.nextToken().trim().toLowerCase();
            }
            if (st.hasMoreTokens()) {
                diIV = st.nextToken().trim().toLowerCase();
            }
        }
        this.dekInfo = diCipher;
        this.iv = PEMUtil.hexToBytes(diIV);
        if (!"".equals(diCipher)) {
            String CIPHER = "UNKNOWN";
            String MODE = "";
            int keySize = -1;
            StringTokenizer st = new StringTokenizer(this.dekInfo, "-");
            if (st.hasMoreTokens()) {
                CIPHER = st.nextToken().toUpperCase();
                if (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (st.hasMoreTokens()) {
                        block17: {
                            try {
                                keySize = Integer.parseInt(tok);
                            }
                            catch (NumberFormatException nfe) {
                                String upper = tok.toUpperCase();
                                if ("EDE3".equals(upper)) {
                                    CIPHER = "DESede";
                                }
                                if (!"EDE".equals(upper)) break block17;
                                CIPHER = "DESede";
                                doubleDES = true;
                            }
                        }
                        MODE = st.nextToken().toUpperCase();
                    } else {
                        MODE = tok.toUpperCase();
                        if ("EDE".equals(MODE)) {
                            CIPHER = "DESede";
                            MODE = "ECB";
                            doubleDES = true;
                        } else if ("EDE3".equals(MODE)) {
                            CIPHER = "DESede";
                            MODE = "ECB";
                        }
                    }
                }
            }
            if ("BF".equals(CIPHER)) {
                CIPHER = "Blowfish";
            }
            this.mode = MODE;
            this.cipher = CIPHER;
            this.keySizeInBits = keySize == -1 ? (CIPHER.startsWith("DESede") ? 192 : (CIPHER.startsWith("DES") ? 64 : 128)) : keySize;
        } else {
            this.mode = "";
            this.cipher = "UNKNOWN";
            this.keySizeInBits = -1;
        }
        this.des2 = doubleDES;
    }

    public byte[] getDerBytes() {
        byte[] b = new byte[this.derBytes.length];
        System.arraycopy(this.derBytes, 0, b, 0, this.derBytes.length);
        return b;
    }
}

