/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.SSLServer;
import org.apache.commons.ssl.SSLServerSocketWrapper;
import org.apache.commons.ssl.SSLSocketWrapper;
import org.apache.commons.ssl.SSLWrapperFactory;

public class DefaultSSLWrapperFactory
implements SSLWrapperFactory {
    private static final DefaultSSLWrapperFactory instance = new DefaultSSLWrapperFactory();

    private DefaultSSLWrapperFactory() {
    }

    public static DefaultSSLWrapperFactory getInstance() {
        return instance;
    }

    public SSLSocket wrap(SSLSocket s) {
        return new SSLSocketWrapper(s);
    }

    public SSLServerSocket wrap(SSLServerSocket s, SSLServer server) throws IOException {
        boolean java13 = JavaImpl.isJava13();
        return java13 ? s : new SSLServerSocketWrapper(s, server, this);
    }
}

