/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.Procedure;
import org.h2.engine.SessionInterface;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.jdbc.JdbcConnection;
import org.h2.log.InDoubtTransaction;
import org.h2.log.LogSystem;
import org.h2.log.UndoLog;
import org.h2.log.UndoLogRecord;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.DataHandler;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class Session
implements SessionInterface {
    private User user;
    private int id;
    private Database database;
    private ObjectArray locks = new ObjectArray();
    private UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private LogSystem logSystem;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap savepoints;
    private Exception stackTrace = new Exception();
    private HashMap localTempTables;
    private int throttle;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private String traceModuleName;
    private HashMap unlinkMap;
    private int tempViewIndex;
    private HashMap procedures;
    private static int nextSerialId;
    private int serialId = nextSerialId++;
    private boolean undoLogEnabled = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAt;
    private boolean closed;
    private boolean rollbackMode;
    private long sessionStart = System.currentTimeMillis();
    private long currentCommandStart;
    private HashMap variables;
    private HashSet temporaryResults;
    private int queryTimeout = SysProperties.getMaxQueryTimeout();
    private int lastUncommittedDelete;
    private boolean commitOrRollbackDisabled;

    public Session() {
    }

    public boolean setCommitOrRollbackDisabled(boolean x) {
        boolean old = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = x;
        return old;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = new HashMap();
        }
    }

    public void setVariable(String name, Value value) throws SQLException {
        Value old;
        this.initVariables();
        if (value == ValueNull.INSTANCE) {
            old = (Value)this.variables.remove(name);
        } else {
            if (value instanceof ValueLob) {
                value = value.link(this.database, -1);
            }
            old = this.variables.put(name, value);
        }
        if (old != null) {
            old.unlink();
            old.close();
        }
    }

    public Value getVariable(String name) {
        this.initVariables();
        Value v = (Value)this.variables.get(name);
        return v == null ? ValueNull.INSTANCE : v;
    }

    public Table findLocalTempTable(String name) {
        Table t = null;
        if (this.localTempTables != null) {
            t = (Table)this.localTempTables.get(name);
        }
        return t;
    }

    public ObjectArray getLocalTempTables() {
        if (this.localTempTables == null) {
            return new ObjectArray();
        }
        ObjectArray list = new ObjectArray(this.localTempTables.values());
        return list;
    }

    public void addLocalTempTable(Table table) throws SQLException {
        if (this.localTempTables == null) {
            this.localTempTables = new HashMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            throw Message.getSQLException(42101, table.getSQL());
        }
        this.localTempTables.put(table.getName(), table);
    }

    public void removeLocalTempTable(Table table) throws SQLException {
        this.localTempTables.remove(table.getName());
        table.removeChildrenAndResources(this);
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (!this.closed) {
            throw Message.getInternalError("not closed", this.stackTrace);
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public SessionInterface createSession(ConnectionInfo ci) throws SQLException {
        return Engine.getInstance().getSession(ci);
    }

    Session(Database database, User user, int id) {
        this.database = database;
        this.undoLog = new UndoLog(this);
        this.user = user;
        this.id = id;
        this.logSystem = database.getLog();
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.lockTimeout = setting == null ? 1000 : setting.getIntValue();
        this.currentSchemaName = "PUBLIC";
    }

    public CommandInterface prepareCommand(String sql, int fetchSize) throws SQLException {
        return this.prepareLocal(sql);
    }

    public Prepared prepare(String sql) throws SQLException {
        return this.prepare(sql, false);
    }

    public Prepared prepare(String sql, boolean rightsChecked) throws SQLException {
        Parser parser = new Parser(this);
        parser.setRightsChecked(rightsChecked);
        return parser.prepare(sql);
    }

    public Command prepareLocal(String sql) throws SQLException {
        if (this.closed) {
            throw Message.getSQLException(90067);
        }
        Parser parser = new Parser(this);
        return parser.prepareCommand(sql);
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    public void setPowerOffCount(int count) {
        this.database.setPowerOffCount(count);
    }

    public int getLastUncommittedDelete() {
        return this.lastUncommittedDelete;
    }

    public void setLastUncommittedDelete(int deleteId) {
        this.lastUncommittedDelete = deleteId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean ddl) throws SQLException {
        this.checkCommitRollback();
        this.lastUncommittedDelete = 0;
        this.currentTransactionName = null;
        if (this.containsUncommitted()) {
            this.logSystem.commit(this);
        }
        if (this.undoLog.size() > 0) {
            if (this.database.isMultiVersion()) {
                ArrayList<Row> rows = new ArrayList<Row>();
                Database database = this.database;
                synchronized (database) {
                    while (this.undoLog.size() > 0) {
                        UndoLogRecord entry = this.undoLog.getAndRemoveLast();
                        entry.commit();
                        rows.add(entry.getRow());
                    }
                    for (int i = 0; i < rows.size(); ++i) {
                        Row r = (Row)rows.get(i);
                        r.commit();
                    }
                }
            }
            this.undoLog.clear();
        }
        if (!ddl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        if (this.unlinkMap != null && this.unlinkMap.size() > 0) {
            this.logSystem.flush();
            Iterator it = this.unlinkMap.values().iterator();
            while (it.hasNext()) {
                Value v = (Value)it.next();
                v.unlink();
            }
            this.unlinkMap = null;
        }
        this.unlockAll();
    }

    private void checkCommitRollback() throws SQLException {
        if (this.commitOrRollbackDisabled && this.locks.size() > 0) {
            throw Message.getSQLException(90058);
        }
    }

    public void rollback() throws SQLException {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        boolean needCommit = false;
        if (this.undoLog.size() > 0) {
            this.rollbackTo(0);
            needCommit = true;
        }
        if (this.locks.size() > 0 || needCommit) {
            this.logSystem.commit(this);
        }
        this.cleanTempTables(false);
        this.unlockAll();
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(int index) throws SQLException {
        while (this.undoLog.size() > index) {
            UndoLogRecord entry = this.undoLog.getAndRemoveLast();
            this.rollbackMode = true;
            try {
                entry.undo(this);
            }
            finally {
                this.rollbackMode = false;
            }
        }
        if (this.savepoints != null) {
            String[] names = new String[this.savepoints.size()];
            this.savepoints.keySet().toArray(names);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Integer id = (Integer)this.savepoints.get(names[i]);
                if (id <= index) continue;
                this.savepoints.remove(name);
            }
        }
    }

    public int getLogId() {
        return this.undoLog.size();
    }

    public int getId() {
        return this.id;
    }

    public void cancel() {
        this.cancelAt = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                this.cleanTempTables(true);
                this.database.removeSession(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.indexOf(table) >= 0) {
            throw Message.getInternalError();
        }
        this.locks.add(table);
    }

    public void log(Table table, short type, Row row) throws SQLException {
        this.log(new UndoLogRecord(table, type, row));
    }

    private void log(UndoLogRecord log) throws SQLException {
        int lockMode;
        if (SysProperties.CHECK && (lockMode = this.database.getLockMode()) != 0 && !this.database.isMultiVersion() && this.locks.indexOf(log.getTable()) < 0 && log.getTable().getTableType() != "TABLE LINK") {
            throw Message.getInternalError();
        }
        if (this.undoLogEnabled) {
            this.undoLog.add(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReadLocks() {
        if (this.database.isMultiVersion()) {
            return;
        }
        for (int i = 0; i < this.locks.size(); ++i) {
            Table t = (Table)this.locks.get(i);
            if (t.isLockedExclusively()) continue;
            Database database = this.database;
            synchronized (database) {
                t.unlock(this);
                this.locks.remove(i);
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockAll() throws SQLException {
        if (SysProperties.CHECK && this.undoLog.size() > 0) {
            throw Message.getInternalError();
        }
        Database database = this.database;
        synchronized (database) {
            for (int i = 0; i < this.locks.size(); ++i) {
                Table t = (Table)this.locks.get(i);
                t.unlock(this);
            }
            this.locks.clear();
        }
        this.savepoints = null;
    }

    private void cleanTempTables(boolean closeSession) throws SQLException {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            ObjectArray list = new ObjectArray(this.localTempTables.values());
            for (int i = 0; i < list.size(); ++i) {
                Table table = (Table)list.get(i);
                if (closeSession || table.isOnCommitDrop()) {
                    table.setModified();
                    this.localTempTables.remove(table.getName());
                    table.removeChildrenAndResources(this);
                    continue;
                }
                if (!table.isOnCommitTruncate()) continue;
                table.truncate(this);
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    public Trace getTrace() {
        if (this.traceModuleName == null) {
            this.traceModuleName = "jdbc[" + this.id + "]";
        }
        if (this.closed) {
            return new TraceSystem(null, false).getTrace(this.traceModuleName);
        }
        return this.database.getTrace(this.traceModuleName);
    }

    public void setLastIdentity(Value last) {
        this.lastIdentity = last;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void addLogPos(int logId, int pos) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = logId;
            this.firstUncommittedPos = pos;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    public int getFirstUncommittedPos() {
        return this.firstUncommittedPos;
    }

    public void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    private boolean containsUncommitted() {
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String name) {
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        this.savepoints.put(name, ObjectUtils.getInteger(this.getLogId()));
    }

    public void rollbackToSavepoint(String name) throws SQLException {
        this.checkCommitRollback();
        if (this.savepoints == null) {
            throw Message.getSQLException(90063, name);
        }
        Integer id = (Integer)this.savepoints.get(name);
        if (id == null) {
            throw Message.getSQLException(90063, name);
        }
        int i = id;
        this.rollbackTo(i);
    }

    public void prepareCommit(String transactionName) throws SQLException {
        if (this.containsUncommitted()) {
            this.logSystem.prepareCommit(this, transactionName);
        }
        this.currentTransactionName = transactionName;
    }

    public void setPreparedTransaction(String transactionName, boolean commit) throws SQLException {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(transactionName)) {
            if (commit) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ObjectArray list = this.logSystem.getInDoubtTransactions();
            int state = commit ? 1 : 2;
            boolean found = false;
            for (int i = 0; list != null && i < list.size(); ++i) {
                InDoubtTransaction p = (InDoubtTransaction)list.get(i);
                if (!p.getTransaction().equals(transactionName)) continue;
                p.setState(state);
                found = true;
                break;
            }
            if (!found) {
                throw Message.getSQLException(90129, transactionName);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public void throttle() {
        if (this.throttle == 0) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.lastThrottle + 50L > time) {
            return;
        }
        this.lastThrottle = time + (long)this.throttle;
        try {
            Thread.sleep(this.throttle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command, long startTime) {
        this.currentCommand = command;
        this.currentCommandStart = startTime;
        if (this.queryTimeout > 0) {
            this.cancelAt = startTime + (long)this.queryTimeout;
        }
    }

    public void checkCancelled() throws SQLException {
        this.throttle();
        if (this.cancelAt == 0L) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time >= this.cancelAt) {
            this.cancelAt = 0L;
            throw Message.getSQLException(90051);
        }
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public long getCurrentCommandStart() {
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean b) {
        this.allowLiterals = b;
    }

    public void setCurrentSchema(Schema schema) {
        this.currentSchemaName = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public JdbcConnection createConnection(boolean columnList) throws SQLException {
        String url = columnList ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), url);
    }

    public DataHandler getDataHandler() {
        return this.database;
    }

    public void unlinkAtCommit(Value v) {
        if (this.unlinkMap == null) {
            this.unlinkMap = new HashMap();
        }
        this.unlinkMap.put(v.toString(), v);
    }

    public void unlinkAtCommitStop(Value v) {
        if (this.unlinkMap != null) {
            this.unlinkMap.remove(v.toString());
        }
    }

    public String getNextTempViewName() {
        return "TEMP_VIEW_" + this.tempViewIndex++;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = new HashMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String name) {
        if (this.procedures != null) {
            this.procedures.remove(name);
        }
    }

    public Procedure getProcedure(String name) {
        if (this.procedures == null) {
            return null;
        }
        return (Procedure)this.procedures.get(name);
    }

    public void setSchemaSearchPath(String[] schemas) {
        this.schemaSearchPath = schemas;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public void setUndoLogEnabled(boolean b) {
        this.undoLogEnabled = b;
    }

    public boolean getUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public boolean getRollbackMode() {
        return this.rollbackMode;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table[] getLocks() {
        Database database = this.database;
        synchronized (database) {
            Object[] list = new Table[this.locks.size()];
            this.locks.toArray(list);
            return list;
        }
    }

    public void waitIfExclusiveModeEnabled() {
        Session exclusive;
        while ((exclusive = this.database.getExclusiveSession()) != null && exclusive != this) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addTemporaryResult(LocalResult result) {
        if (this.temporaryResults == null) {
            this.temporaryResults = new HashSet();
        }
        this.temporaryResults.add(result);
    }

    public void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            Iterator it = this.temporaryResults.iterator();
            while (it.hasNext()) {
                LocalResult result = (LocalResult)it.next();
                result.close();
            }
        }
    }

    public void setQueryTimeout(int queryTimeout) {
        int max = SysProperties.getMaxQueryTimeout();
        if (max != 0 && (max < queryTimeout || queryTimeout == 0)) {
            queryTimeout = max;
        }
        this.queryTimeout = queryTimeout;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }
}

