/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.ResourceConfigurationNotFoundException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryUnitConfigMap;
import org.milyn.delivery.ContentDeliveryUnitConfigMapTable;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.dom.serialize.Serializer;
import org.milyn.xml.DomUtils;
import org.milyn.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmooksDOMFilter {
    private Log logger = LogFactory.getLog(SmooksDOMFilter.class);
    private ExecutionContext executionContext;
    private DOMContentDeliveryConfig deliveryConfig;
    private List<ContentDeliveryUnitConfigMap> globalProcessingUnits;
    public static final String DELIVERY_NODE_REQUEST_KEY = ContentDeliveryConfig.class.getName() + "#DELIVERY_NODE_REQUEST_KEY";
    private static ThreadLocal<ExecutionContext> requestThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmooksDOMFilter(ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in constructor call.");
        }
        this.executionContext = executionContext;
        ThreadLocal<ExecutionContext> threadLocal = requestThreadLocal;
        synchronized (threadLocal) {
            requestThreadLocal.set(executionContext);
        }
        this.deliveryConfig = (DOMContentDeliveryConfig)executionContext.getDeliveryConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        ThreadLocal<ExecutionContext> threadLocal = requestThreadLocal;
        synchronized (threadLocal) {
            try {
                ExecutionContext curExecutionContext = SmooksDOMFilter.getContainerRequest();
                if (this.executionContext == curExecutionContext) {
                    requestThreadLocal.remove();
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    public static ExecutionContext getContainerRequest() {
        return requestThreadLocal.get();
    }

    private void assertNotInterleaved() {
        ExecutionContext curExecutionContext = SmooksDOMFilter.getContainerRequest();
        if (this.executionContext != curExecutionContext) {
            throw new Error("Illegal interleaving of multiple instances of " + SmooksDOMFilter.class.getName() + ".  See class Javadocs.");
        }
    }

    public Node filter(Reader source) throws SmooksException {
        Node deliveryNode;
        this.assertNotInterleaved();
        if (source == null) {
            throw new IllegalArgumentException("null 'source' arg passed in method call.");
        }
        try {
            Parser parser = new Parser(this.executionContext);
            Document document = parser.parse(source);
            deliveryNode = this.filter(document);
        }
        catch (Exception cause) {
            throw new SmooksException("Unable to filter InputStream for target profile [" + this.executionContext.getTargetProfiles().getBaseProfile() + "].", cause);
        }
        return deliveryNode;
    }

    public Node filter(Document doc) {
        this.assertNotInterleaved();
        Vector transList = new Vector();
        if (doc.getDocumentElement() == null) {
            this.logger.warn((Object)("Empty Document [" + this.executionContext.getDocumentSource() + "].  Not performaing any processing."));
            return doc;
        }
        ContentDeliveryUnitConfigMapTable assemblyUnits = this.deliveryConfig.getAssemblyUnits();
        if (!assemblyUnits.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Starting assembly phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
            }
            this.assemble(doc.getDocumentElement(), true);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No assembly units configured for device [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting processing phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
        }
        this.globalProcessingUnits = this.deliveryConfig.getProcessingUnits().getMappings("*");
        this.buildProcessingList(transList, doc.getDocumentElement(), true);
        int transListLength = transList.size();
        for (int i = 0; i < transListLength; ++i) {
            ElementProcessor elementTrans = (ElementProcessor)transList.get(i);
            elementTrans.process(this.executionContext);
        }
        Node deliveryNode = (Node)this.executionContext.getAttribute(DELIVERY_NODE_REQUEST_KEY);
        if (deliveryNode == null) {
            deliveryNode = doc;
        }
        return deliveryNode;
    }

    private void assemble(Element element, boolean isRoot) {
        DOMElementVisitor assemblyUnit;
        SmooksResourceConfiguration config;
        ContentDeliveryUnitConfigMap configMap;
        int i;
        List nodeListCopy = this.copyList(element.getChildNodes());
        int childCount = nodeListCopy.size();
        ContentDeliveryUnitConfigMapTable assemblyUnits = this.deliveryConfig.getAssemblyUnits();
        String elementName = DomUtils.getName(element);
        List<ContentDeliveryUnitConfigMap> elementAssemblyUnits = isRoot ? assemblyUnits.getMappings(new String[]{elementName, "$document"}) : assemblyUnits.getMappings(elementName);
        if (elementAssemblyUnits != null && !elementAssemblyUnits.isEmpty()) {
            for (i = 0; i < elementAssemblyUnits.size(); ++i) {
                configMap = elementAssemblyUnits.get(i);
                config = configMap.getResourceConfig();
                if (!config.isTargetedAtElement(element)) continue;
                assemblyUnit = (DOMElementVisitor)configMap.getContentDeliveryUnit();
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("(Assembly) Calling visitBefore on element [" + DomUtils.getXPath(element) + "]. Config [" + config + "]"));
                    }
                    assemblyUnit.visitBefore(element, this.executionContext);
                    continue;
                }
                catch (Throwable e) {
                    this.logger.error((Object)("(Assembly) visitBefore failed [" + assemblyUnit.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "]."), e);
                }
            }
        }
        for (i = 0; i < childCount; ++i) {
            Node child = (Node)nodeListCopy.get(i);
            if (child.getNodeType() != 1) continue;
            this.assemble((Element)child, false);
        }
        if (elementAssemblyUnits != null && !elementAssemblyUnits.isEmpty()) {
            for (i = 0; i < elementAssemblyUnits.size(); ++i) {
                configMap = elementAssemblyUnits.get(i);
                config = configMap.getResourceConfig();
                if (!config.isTargetedAtElement(element)) continue;
                assemblyUnit = (DOMElementVisitor)configMap.getContentDeliveryUnit();
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("(Assembly) Calling visitAfter on element [" + DomUtils.getXPath(element) + "]. Config [" + config + "]"));
                    }
                    assemblyUnit.visitAfter(element, this.executionContext);
                    continue;
                }
                catch (Throwable e) {
                    this.logger.error((Object)("(Assembly) visitAfter failed [" + assemblyUnit.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "]."), e);
                }
            }
        }
    }

    private void buildProcessingList(List processingList, Element element, boolean isRoot) {
        List<ContentDeliveryUnitConfigMap> processingUnits = null;
        String elementName = DomUtils.getName(element);
        processingUnits = isRoot ? this.deliveryConfig.getProcessingUnits().getMappings(new String[]{elementName, "$document"}) : this.deliveryConfig.getProcessingUnits().getMappings(elementName);
        if (processingUnits != null && !processingUnits.isEmpty()) {
            processingList.add(new ElementProcessor(element, processingUnits, true));
        }
        if (this.globalProcessingUnits != null) {
            processingList.add(new ElementProcessor(element, this.globalProcessingUnits, true));
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.buildProcessingList(processingList, (Element)child, false);
        }
        if (processingUnits != null) {
            processingList.add(new ElementProcessor(element, processingUnits, false));
        }
        if (this.globalProcessingUnits != null) {
            processingList.add(new ElementProcessor(element, this.globalProcessingUnits, false));
        }
    }

    public void serialize(Node node, Writer writer) throws IOException, SmooksException {
        this.assertNotInterleaved();
        if (node == null) {
            throw new IllegalArgumentException("null 'doc' arg passed in method call.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null 'writer' arg passed in method call.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting serialization phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
        }
        Serializer serializer = new Serializer(node, this.executionContext);
        try {
            serializer.serailize(writer);
        }
        catch (ResourceConfigurationNotFoundException e) {
            throw new SmooksException("Unable to serialize document.", e);
        }
    }

    private List copyList(NodeList nodeList) {
        Vector<Node> copy = new Vector<Node>(nodeList.getLength());
        int nodeCount = nodeList.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            copy.add(nodeList.item(i));
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementProcessor {
        private Element element;
        private List<ContentDeliveryUnitConfigMap> processingUnits;
        private boolean visitBefore;

        private ElementProcessor(Element element, List<ContentDeliveryUnitConfigMap> processingUnits, boolean visitBefore) {
            this.element = element;
            this.processingUnits = processingUnits;
            this.visitBefore = visitBefore;
        }

        private void process(ExecutionContext executionContext) {
            int loopLength = this.processingUnits.size();
            for (int i = 0; i < loopLength; ++i) {
                ContentDeliveryUnitConfigMap configMap = this.processingUnits.get(i);
                SmooksResourceConfiguration config = configMap.getResourceConfig();
                if (!config.isTargetedAtElement(this.element)) continue;
                DOMElementVisitor processingUnit = (DOMElementVisitor)configMap.getContentDeliveryUnit();
                try {
                    if (SmooksDOMFilter.this.logger.isDebugEnabled()) {
                        SmooksDOMFilter.this.logger.debug((Object)("Applying processing resource [" + config + "] to element [" + DomUtils.getXPath(this.element) + "] " + (this.visitBefore ? "before" : "after") + " apply resources to its child elements."));
                    }
                    if (this.visitBefore) {
                        processingUnit.visitBefore(this.element, executionContext);
                        continue;
                    }
                    processingUnit.visitAfter(this.element, executionContext);
                    continue;
                }
                catch (Throwable e) {
                    SmooksDOMFilter.this.logger.error((Object)("Failed to apply processing unit [" + processingUnit.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "]."), e);
                }
            }
        }
    }
}

