/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitConfigMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDeliveryUnitConfigMapTable {
    private Map<String, List<ContentDeliveryUnitConfigMap>> targetMapTable = new Hashtable<String, List<ContentDeliveryUnitConfigMap>>();
    private int count = 0;

    public void addMapping(String selector, SmooksResourceConfiguration resourceConfig, ContentDeliveryUnit deliveryUnit) {
        List<ContentDeliveryUnitConfigMap> selectorMappings = this.targetMapTable.get(selector.toLowerCase());
        if (selectorMappings == null) {
            selectorMappings = new Vector<ContentDeliveryUnitConfigMap>();
            this.targetMapTable.put(selector.toLowerCase(), selectorMappings);
        }
        ContentDeliveryUnitConfigMap mapInst = new ContentDeliveryUnitConfigMap(deliveryUnit, resourceConfig);
        selectorMappings.add(mapInst);
        ++this.count;
    }

    public List<ContentDeliveryUnitConfigMap> getMappings(String selector) {
        return this.targetMapTable.get(selector.toLowerCase());
    }

    public List<ContentDeliveryUnitConfigMap> getMappings(String[] selectors) {
        ArrayList<ContentDeliveryUnitConfigMap> combinedList = new ArrayList<ContentDeliveryUnitConfigMap>();
        for (String selector : selectors) {
            List<ContentDeliveryUnitConfigMap> selectorList = this.targetMapTable.get(selector.toLowerCase());
            if (selectorList == null) continue;
            combinedList.addAll(selectorList);
        }
        return combinedList;
    }

    public boolean isEmpty() {
        return this.targetMapTable.isEmpty();
    }

    public int getCount() {
        return this.count;
    }
}

