/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.ClasspathUtils;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.XMLConfigDigester;
import org.milyn.container.ApplicationContext;
import org.milyn.container.standalone.StandaloneApplicationContext;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitCreator;
import org.milyn.delivery.UnsupportedContentDeliveryUnitTypeException;
import org.milyn.profile.DefaultProfileStore;
import org.milyn.profile.ProfileSet;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.util.ClassUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksResourceConfigurationStore {
    private static Log logger = LogFactory.getLog(SmooksResourceConfigurationStore.class);
    private List<SmooksResourceConfigurationList> configLists = new Vector<SmooksResourceConfigurationList>();
    private SmooksResourceConfigurationList defaultList = new SmooksResourceConfigurationList("default");
    private ApplicationContext applicationContext;

    public SmooksResourceConfigurationStore(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg in constructor call.");
        }
        this.applicationContext = applicationContext;
        this.configLists.add(this.defaultList);
        this.registerInstalledResources("installed-cdu-creators.cdrl");
        this.registerInstalledResources("installed-param-decoders.cdrl");
        this.registerInstalledResources("installed-serializers.cdrl");
    }

    private void registerInstalledResources(String resourceFile) {
        InputStream resource = ClassUtil.getResourceAsStream((String)resourceFile, this.getClass());
        if (resource == null) {
            throw new IllegalStateException("Failed to load " + resourceFile + ".  Expected to be in the same package as " + this.getClass().getName());
        }
        try {
            this.registerResources(resourceFile, resource);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error processing resource file '" + resourceFile + "'.", e);
        }
    }

    public void load(BufferedReader cdrlLoadList) throws IOException {
        String uri;
        ContainerResourceLocator resLocator = this.applicationContext.getResourceLocator();
        while ((uri = cdrlLoadList.readLine()) != null) {
            if ((uri = uri.trim()).equals("") || uri.charAt(0) == '#') continue;
            try {
                InputStream resource = resLocator.getResource(uri);
                logger.info((Object)("Loading Smooks Resources from uri [" + uri + "]."));
                this.registerResources(uri, resource);
                logger.debug((Object)("[" + uri + "] Loaded."));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void registerResources(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException, URISyntaxException {
        if (baseURI == null || baseURI.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in method call.");
        }
        if (resourceConfigStream == null) {
            throw new IllegalArgumentException("null 'resourceConfigStream' arg in method call.");
        }
        SmooksResourceConfigurationList configList = XMLConfigDigester.digestConfig(resourceConfigStream, baseURI);
        this.configLists.add(configList);
        this.addProfileSets(configList.getProfiles());
    }

    private void addProfileSets(List<ProfileSet> profileSets) {
        if (profileSets == null) {
            return;
        }
        if (this.applicationContext instanceof StandaloneApplicationContext) {
            DefaultProfileStore profileStore = ((StandaloneApplicationContext)this.applicationContext).getProfileStore();
            for (ProfileSet profileSet : profileSets) {
                profileStore.addProfileSet(profileSet);
            }
            profileStore.expandProfiles();
        }
    }

    public void registerResource(SmooksResourceConfiguration resourceConfig) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("null 'resourceConfig' arg in method call.");
        }
        this.defaultList.add(resourceConfig);
    }

    public Iterator<SmooksResourceConfigurationList> getSmooksResourceConfigurationLists() {
        return this.configLists.iterator();
    }

    public SmooksResourceConfiguration[] getSmooksResourceConfigurations(ProfileSet profileSet) {
        Vector<SmooksResourceConfiguration> allSmooksResourceConfigurationsColl = new Vector<SmooksResourceConfiguration>();
        for (int i = 0; i < this.configLists.size(); ++i) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            SmooksResourceConfiguration[] resourceConfigs = list.getTargetConfigurations(profileSet);
            allSmooksResourceConfigurationsColl.addAll(Arrays.asList(resourceConfigs));
        }
        SmooksResourceConfiguration[] allSmooksResourceConfigurations = new SmooksResourceConfiguration[allSmooksResourceConfigurationsColl.size()];
        allSmooksResourceConfigurationsColl.toArray(allSmooksResourceConfigurations);
        return allSmooksResourceConfigurations;
    }

    public Object getObject(SmooksResourceConfiguration resourceConfig) {
        Class classRuntime;
        Object object = null;
        String className = ClasspathUtils.toClassName(resourceConfig.getResource());
        try {
            classRuntime = ClassUtil.forName((String)className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            IllegalStateException state = new IllegalStateException("Error loading Java class: " + className);
            state.initCause(e);
            throw state;
        }
        try {
            Constructor constructor = classRuntime.getConstructor(SmooksResourceConfiguration.class);
            object = constructor.newInstance(resourceConfig);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            IllegalStateException state = new IllegalStateException("Error loading Java class: " + className);
            state.initCause(e);
            throw state;
        }
        if (object == null) {
            try {
                object = classRuntime.newInstance();
            }
            catch (Exception e) {
                IllegalStateException state = new IllegalStateException("Java class " + className + " must contain a default constructor if it does not contain a constructor that takes an instance of " + SmooksResourceConfiguration.class.getName() + ".");
                state.initCause(e);
                throw state;
            }
        }
        if (object instanceof ContentDeliveryUnit) {
            ((ContentDeliveryUnit)object).setConfiguration(resourceConfig);
        }
        return object;
    }

    public ContentDeliveryUnitCreator getContentDeliveryUnitCreator(String type) throws UnsupportedContentDeliveryUnitTypeException {
        if (type == null) {
            throw new IllegalArgumentException("null 'resourceExtension' arg in method call.");
        }
        for (int i = 0; i < this.configLists.size(); ++i) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            for (int ii = 0; ii < list.size(); ++ii) {
                SmooksResourceConfiguration config = list.get(ii);
                String selector = config.getSelector();
                if (!"cdu-creator".equals(selector) || !type.equalsIgnoreCase(config.getStringParameter("restype"))) continue;
                return (ContentDeliveryUnitCreator)this.getObject(config);
            }
        }
        throw new UnsupportedContentDeliveryUnitTypeException(type);
    }
}

