/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.util.List;
import org.milyn.cdr.ParameterDecodeException;
import org.milyn.cdr.ParameterDecoder;
import org.milyn.delivery.ContentDeliveryConfig;
import org.w3c.dom.Element;

public class Parameter {
    public static final String PARAM_TYPE_PREFIX = "param-type:";
    private String name;
    String value;
    private String type;
    private Object objValue;
    private Element xml;

    public Parameter(String name, String value) {
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in constructor call.");
        }
        if (value == null) {
            throw new IllegalArgumentException("null 'value' arg in constructor call.");
        }
        this.name = name;
        this.value = value;
    }

    public Parameter(String name, String value, String type) {
        this(name, value);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(ContentDeliveryConfig deliveryConfig) throws ParameterDecodeException {
        if (this.objValue == null) {
            String string = this.value;
            synchronized (string) {
                if (this.objValue == null) {
                    if (this.type == null) {
                        this.objValue = this.value;
                    } else {
                        List decoders = deliveryConfig.getObjects(PARAM_TYPE_PREFIX + this.type);
                        if (!decoders.isEmpty()) {
                            try {
                                ParameterDecoder paramDecoder = (ParameterDecoder)decoders.get(0);
                                this.objValue = paramDecoder.decodeValue(this.value);
                            }
                            catch (ClassCastException cast) {
                                throw new ParameterDecodeException("Configured ParameterDecoder 'param-type:" + this.type + "' for device must be of type " + ParameterDecoder.class);
                            }
                        } else {
                            throw new ParameterDecodeException("ParameterDecoder 'param-type:" + this.type + "' not defined for requesting device.");
                        }
                    }
                }
            }
        }
        return this.objValue;
    }

    public String toString() {
        return this.value;
    }

    protected void setXML(Element xml) {
        this.xml = xml;
    }

    public Element getXml() {
        return this.xml;
    }
}

