/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.xslt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitCreator;
import org.milyn.io.StreamUtils;
import org.milyn.templating.AbstractTemplateProcessingUnit;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XslContentDeliveryUnitCreator
implements ContentDeliveryUnitCreator {
    public static final String IS_XSLT_TEMPLATELET = "is-xslt-templatelet";
    private static Log logger = LogFactory.getLog(XslContentDeliveryUnitCreator.class);
    public static final String ORG_MILYN_TEMPLATING_XSLT_SYNCHRONIZED = "org.milyn.templating.xslt.synchronized";

    public XslContentDeliveryUnitCreator(SmooksResourceConfiguration config) {
    }

    public synchronized ContentDeliveryUnit create(SmooksResourceConfiguration resourceConfig) throws InstantiationException {
        try {
            XslProcessingUnit xslProcessingUnit = new XslProcessingUnit();
            xslProcessingUnit.setConfiguration(resourceConfig);
            return xslProcessingUnit;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("XSL ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    private class XslProcessingUnit
    extends AbstractTemplateProcessingUnit {
        private Templates xslTemplate;
        private boolean isTemplatelet;
        private boolean streamResult;
        private final boolean isSynchronized = Boolean.getBoolean("org.milyn.templating.xslt.synchronized");

        private XslProcessingUnit() {
        }

        protected void loadTemplate(SmooksResourceConfiguration resourceConfig) throws IOException, TransformerConfigurationException {
            boolean isInlineXSL;
            byte[] xslBytes = resourceConfig.getBytes();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            String encoding = resourceConfig.getStringParameter("encoding", "UTF-8");
            try {
                new URI(resourceConfig.getResource());
                isInlineXSL = false;
            }
            catch (Exception e) {
                isInlineXSL = true;
            }
            this.isTemplatelet = this.isTemplatelet(isInlineXSL, resourceConfig, new String(xslBytes));
            if (this.isTemplatelet) {
                String templateletWrapper = new String(StreamUtils.readStream((InputStream)ClassUtil.getResourceAsStream((String)"doc-files/templatelet.xsl", this.getClass())));
                String templatelet = new String(xslBytes);
                templateletWrapper = StringUtils.replace((String)templateletWrapper, (String)"@@@templatelet@@@", (String)templatelet);
                xslBytes = templateletWrapper.getBytes();
            }
            StreamSource xslStreamSource = new StreamSource(new InputStreamReader((InputStream)new ByteArrayInputStream(xslBytes), encoding));
            this.xslTemplate = transformerFactory.newTemplates(xslStreamSource);
            this.streamResult = resourceConfig.getBoolParameter("streamResult", true);
        }

        private boolean isTemplatelet(boolean inlineXSL, SmooksResourceConfiguration resourceConfig, String templateCode) {
            boolean isTemplatelet;
            boolean bl = isTemplatelet = inlineXSL && resourceConfig.getBoolParameter(XslContentDeliveryUnitCreator.IS_XSLT_TEMPLATELET, false);
            if (isTemplatelet && templateCode.indexOf(":stylesheet>") != -1) {
                logger.warn((Object)("The following XSL resource is configured as a templatelet, but looks as though it may be a complete stylesheet i.e. not a templatelet. You may want to remove the 'is-xslt-templatelet' parameter. Resource:\n" + resourceConfig));
            }
            if (!isTemplatelet && templateCode.indexOf(":stylesheet>") == -1) {
                logger.warn((Object)("The following XSL resource is NOT configured as a templatelet, but looks as though it may be an incomplete stylesheet i.e. it may be templatelet.  If so, it must be explicitly configured as a templatelet. Resource:\n" + resourceConfig));
            }
            return isTemplatelet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visit(Element element, ExecutionContext executionContext) {
            Element dontRemoveEl;
            NodeList children;
            Element transRes;
            block6: {
                Document ownerDoc = element.getOwnerDocument();
                transRes = ownerDoc.createElement("xsltrans");
                children = null;
                try {
                    if (this.isSynchronized) {
                        Templates templates = this.xslTemplate;
                        synchronized (templates) {
                            this.performTransform(element, transRes, ownerDoc);
                            break block6;
                        }
                    }
                    this.performTransform(element, transRes, ownerDoc);
                }
                catch (Exception e) {
                    logger.error((Object)("Error applying XSLT to node [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath((Node)element) + "]"), (Throwable)e);
                    return;
                }
            }
            children = this.isTemplatelet ? ((dontRemoveEl = DomUtils.getElement((Element)transRes, (String)"root-do-not-remove", (int)1, (String)Namespace.SMOOKS_URI)) != null ? dontRemoveEl.getChildNodes() : transRes.getChildNodes()) : transRes.getChildNodes();
            this.processTemplateAction(element, children);
        }

        private void performTransform(Element element, Element transRes, Document ownerDoc) throws TransformerException {
            Transformer transformer = this.xslTemplate.newTransformer();
            transformer.transform(new DOMSource(element), new DOMResult(transRes));
        }
    }
}

