/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PerClassAdvice;
import org.jboss.aop.advice.PerInstanceAdvice;
import org.jboss.aop.advice.PerJoinpointAdvice;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.Joinpoint;

public class AdviceFactory
implements InterceptorFactory {
    private String advice;
    private AspectDefinition aspect;

    public AdviceFactory(AspectDefinition aspect, String adviceName) {
        this.aspect = aspect;
        this.advice = adviceName;
    }

    public AspectDefinition getAspect() {
        return this.aspect;
    }

    public String getAdvice() {
        return this.advice;
    }

    public boolean isDeployed() {
        return this.aspect.isDeployed();
    }

    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        if (this.aspect.getScope() == Scope.PER_VM) {
            try {
                return PerVmAdvice.generateOptimized(joinpoint, advisor.getManager(), this.advice, this.aspect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_CLASS) {
            try {
                return PerClassAdvice.generate(joinpoint, advisor, this.advice, this.aspect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_INSTANCE) {
            return new PerInstanceAdvice(this.advice, this.aspect, advisor);
        }
        if (this.aspect.getScope() == Scope.PER_JOINPOINT) {
            try {
                return PerJoinpointAdvice.createInterceptor(advisor, joinpoint, this.aspect, this.advice);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_CLASS_JOINPOINT) {
            try {
                return PerVmAdvice.generateInterceptor(joinpoint, this.aspect.getFactory().createPerJoinpoint(advisor, joinpoint), this.advice);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getName() {
        return this.aspect.getName() + "." + this.advice;
    }
}

