/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.FinderException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler;
import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryFactory;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.EJBSelectBridge;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.proxy.compiler.InvocationHandler;
import org.jboss.proxy.compiler.Proxy;

public class InstanceFactory {
    private final Class beanClass;
    private final Constructor beanProxyConstructor;
    private final Map fieldMap;
    private final Map selectorMap;

    public InstanceFactory(JDBCStoreManager2 manager, JDBCEntityBridge2 entity) throws Exception {
        EntityContainer theContainer = manager.getContainer();
        this.beanClass = theContainer.getBeanClass();
        this.fieldMap = InstanceFactory.createFieldMap(entity);
        this.selectorMap = InstanceFactory.createSelectorMap(entity, manager.getQueryFactory());
        EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
        Class[] classes = new Class[]{this.beanClass};
        ClassLoader classLoader = this.beanClass.getClassLoader();
        Object o = Proxy.newProxyInstance(classLoader, classes, handler);
        this.beanProxyConstructor = o.getClass().getConstructor(InvocationHandler.class);
        this.newInstance();
    }

    public void destroy() {
        Proxy.forgetProxyForClass(this.beanClass);
    }

    public Object newInstance() throws Exception {
        EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
        return this.beanProxyConstructor.newInstance(handler);
    }

    private static Map getAbstractAccessors(Class beanClass) {
        Method[] methods = beanClass.getMethods();
        HashMap<String, Method> abstractAccessors = new HashMap<String, Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String methodName;
            if (!Modifier.isAbstract(methods[i].getModifiers()) || !(methodName = methods[i].getName()).startsWith("get") && !methodName.startsWith("set")) continue;
            abstractAccessors.put(methodName, methods[i]);
        }
        return abstractAccessors;
    }

    private static Map createFieldMap(JDBCEntityBridge2 entityBridge) throws DeploymentException {
        Map abstractAccessors = InstanceFactory.getAbstractAccessors(entityBridge.getMetaData().getEntityClass());
        List fields = entityBridge.getFields();
        HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker> map = new HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker>(fields.size() * 2);
        for (int i = 0; i < fields.size(); ++i) {
            FieldBridge field = (FieldBridge)fields.get(i);
            String fieldName = field.getFieldName();
            String fieldBaseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String getterName = "get" + fieldBaseName;
            String setterName = "set" + fieldBaseName;
            Method getterMethod = (Method)abstractAccessors.get(getterName);
            Method setterMethod = (Method)abstractAccessors.get(setterName);
            if (getterMethod != null && setterMethod == null) {
                throw new DeploymentException("Getter was found but, no setter was found for field: " + fieldName);
            }
            if (getterMethod == null && setterMethod != null) {
                throw new DeploymentException("Setter was found but, no getter was found for field: " + fieldName);
            }
            if (getterMethod == null || setterMethod == null) continue;
            map.put(getterMethod.getName(), new EntityBridgeInvocationHandler.FieldGetInvoker(field));
            map.put(setterMethod.getName(), new EntityBridgeInvocationHandler.FieldSetInvoker(field));
            abstractAccessors.remove(getterName);
            abstractAccessors.remove(setterName);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map createSelectorMap(JDBCEntityBridge2 entityBridge, QueryFactory queryFactory) throws DeploymentException {
        Collection queries = entityBridge.getMetaData().getQueries();
        HashMap<Method, EJBSelectBridge> selectorsByMethod = new HashMap<Method, EJBSelectBridge>(queries.size());
        for (JDBCQueryMetaData metadata : queries) {
            if (!metadata.getMethod().getName().startsWith("ejbSelect")) continue;
            try {
                QueryCommand queryCommand = queryFactory.getQueryCommand(metadata.getMethod());
                Schema schema = ((JDBCStoreManager2)entityBridge.getManager()).getSchema();
                EJBSelectBridge ejbSelectBridge = new EJBSelectBridge(entityBridge.getContainer(), schema, metadata, queryCommand);
                selectorsByMethod.put(metadata.getMethod(), ejbSelectBridge);
            }
            catch (FinderException e) {
                throw new DeploymentException(e.getMessage());
            }
        }
        return selectorsByMethod;
    }
}

