/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.Handle;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.StatefulRuleSession;
import org.drools.FactHandle;
import org.drools.ObjectFilter;
import org.drools.StatefulSession;
import org.drools.jsr94.rules.AbstractRuleSessionImpl;
import org.drools.jsr94.rules.IteratorToList;
import org.drools.jsr94.rules.ObjectFilterAdapter;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

public class StatefulRuleSessionImpl
extends AbstractRuleSessionImpl
implements StatefulRuleSession {
    private static final long serialVersionUID = 400L;
    private StatefulSession session;

    StatefulRuleSessionImpl(String bindUri, Map properties, RuleExecutionSetRepository repository) throws RuleExecutionSetNotFoundException {
        super(repository);
        this.setProperties(properties);
        RuleExecutionSetImpl ruleSet = (RuleExecutionSetImpl)repository.getRuleExecutionSet(bindUri);
        if (ruleSet == null) {
            throw new RuleExecutionSetNotFoundException("no execution set bound to: " + bindUri);
        }
        this.setRuleExecutionSet(ruleSet);
        this.initSession(true);
    }

    protected void initSession(boolean keepReference) {
        this.session = this.getRuleExecutionSet().newStatefulSession(keepReference);
        Map props = this.getProperties();
        if (props != null) {
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.session.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean containsObject(Handle objectHandle) {
        if (objectHandle instanceof FactHandle) {
            return this.session.getObject((FactHandle)objectHandle) != null;
        }
        return false;
    }

    public Handle addObject(Object object) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return (Handle)this.session.insert(object);
    }

    public List addObjects(List objList) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList<Handle> handles = new ArrayList<Handle>();
        Iterator objectIter = objList.iterator();
        while (objectIter.hasNext()) {
            handles.add(this.addObject(objectIter.next()));
        }
        return handles;
    }

    public void updateObject(Handle objectHandle, Object newObject) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (!(objectHandle instanceof FactHandle)) {
            throw new InvalidHandleException("invalid handle");
        }
        this.session.update((FactHandle)objectHandle, newObject);
    }

    public void removeObject(Handle handleObject) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (!(handleObject instanceof FactHandle)) {
            throw new InvalidHandleException("invalid handle");
        }
        this.session.retract((FactHandle)handleObject);
    }

    public void executeRules() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        this.session.fireAllRules();
    }

    public Object getObject(Handle handle) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handle instanceof FactHandle) {
            return this.session.getObject((FactHandle)handle);
        }
        throw new InvalidHandleException("invalid handle");
    }

    public List getHandles() {
        return IteratorToList.convert(this.session.iterateFactHandles());
    }

    public List getObjects() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return this.getObjects(this.getRuleExecutionSet().getObjectFilter());
    }

    public List getObjects(javax.rules.ObjectFilter filter) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return IteratorToList.convert(this.session.iterateObjects((ObjectFilter)new ObjectFilterAdapter(filter)));
    }

    public void reset() {
        this.initSession(true);
    }

    public int getType() throws InvalidRuleSessionException {
        return 0;
    }

    public void release() {
        if (this.session != null) {
            this.session.dispose();
        }
        this.session = null;
        super.release();
    }

    protected void checkRuleSessionValidity() throws InvalidRuleSessionException {
        if (this.session == null) {
            throw new InvalidRuleSessionException("invalid rule session");
        }
    }
}

