/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import xjava.security.IJCE;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;
import xjava.security.SecretKey;

public abstract class KeyGenerator
implements Parameterized {
    private String W;

    protected KeyGenerator(String string) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.W = string;
    }

    public static KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        return (KeyGenerator)IJCE.getImplementation(string, "KeyGenerator");
    }

    public static KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return (KeyGenerator)IJCE.getImplementation(string, string2, "KeyGenerator");
    }

    public String getAlgorithm() {
        return this.W;
    }

    public abstract void initialize(SecureRandom var1);

    public abstract SecretKey generateKey();

    public void setParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string == null) {
            throw new NullPointerException("param == null");
        }
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string == null) {
            throw new NullPointerException("param == null");
        }
        return this.engineGetParameter(string);
    }

    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + string);
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + string);
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return super.toString() + " KeyGenerator [" + this.W + "]";
    }

    public static String[] getAlgorithms(Provider provider) {
        return IJCE.getAlgorithms(provider, "KeyGenerator");
    }

    public static String[] getAlgorithms() {
        return IJCE.getAlgorithms("KeyGenerator");
    }
}

