/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import xjava.security.Cipher;
import xjava.security.CryptixDebug;
import xjava.security.IJCE;

public class CipherInputStream
extends FilterInputStream {
    private static final int E = IJCE.E("CipherInputStream");
    private Cipher F;
    private final byte[] C = new byte[256];
    private final byte[] B = new byte[256];
    private final byte[] A = new byte[1];
    private byte[] H;
    private int G;
    private int D;
    private boolean I;

    private static String A(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return byArray.toString();
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        int n2 = cipher.getState();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalStateException("cipher is uninitialized");
        }
        this.H = new byte[cipher.getOutputBlockSize()];
        this.D = 0;
        this.G = 0;
        this.I = cipher.isPaddingBlockCipher() && n2 == 2;
        this.F = cipher;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2;
        int n5;
        byte[] byArray3;
        if (E >= 5) {
            CryptixDebug.debug("CipherInputStream", "read(<" + byArray + ">, " + n2 + ", " + n3 + ") ...");
        }
        if (this.F == null) {
            if (E >= 7) {
                CryptixDebug.debug("CipherInputStream", "... stream closed");
            }
            return -1;
        }
        if (n3 <= 0) {
            return 0;
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("offset < 0");
        }
        int n6 = 0;
        if (this.D > 0) {
            n6 = this.D < n3 ? this.D : n3;
            System.arraycopy(this.H, this.G, byArray, n2, n6);
            this.G += n6;
            this.D -= n6;
            n2 += n6;
            n3 -= n6;
            if (E >= 7) {
                CryptixDebug.debug("CipherInputStream", "  outBuf = <" + CipherInputStream.A(this.H) + ">, outPtr = " + this.G + ", buffered = " + this.D + ", offset = " + n2 + ", length = " + n3);
            }
            if (this.D == 0) {
                this.G = 0;
            }
            if (n3 == 0) {
                if (E >= 5) {
                    CryptixDebug.debug("CipherInputStream", "... = " + n6);
                }
                return n6;
            }
        }
        int n7 = this.F.inBufferSize(n3);
        if (this.I) {
            ++n7;
        }
        byte[] byArray4 = byArray3 = n7 <= this.C.length ? this.C : new byte[n7];
        if (E >= 7) {
            CryptixDebug.debug("CipherInputStream", "  inLen = " + n7);
        }
        if ((n5 = this.A(byArray3, 0, n7)) < n7) {
            Cipher cipher = this.F;
            this.F = null;
            int n8 = cipher.outBufferSizeFinal(n5);
            byArray2 = n8 <= this.B.length ? this.B : new byte[n8];
            n4 = cipher.crypt(byArray3, 0, n5, byArray2, 0);
        } else {
            int n9 = this.F.outBufferSize(n5);
            byArray2 = n9 <= this.B.length ? this.B : new byte[n9];
            n4 = this.F.update(byArray3, 0, n5, byArray2, 0);
        }
        if (E >= 7) {
            CryptixDebug.debug("CipherInputStream", "  temp = <" + CipherInputStream.A(byArray2) + ">, n = " + n4);
        }
        if (n4 > n3) {
            this.D = n4 - n3;
            if (this.D > this.H.length) {
                this.H = new byte[this.D];
            }
            System.arraycopy(byArray2, n3, this.H, 0, this.D);
            n4 = n3;
            if (E >= 7) {
                CryptixDebug.debug("CipherInputStream", "  buffered = " + this.D + ", length = " + n3 + ", n = " + n4);
            }
        }
        System.arraycopy(byArray2, 0, byArray, n2, n4);
        if ((n4 += n6) == 0 && this.F == null) {
            n4 = -1;
        }
        if (E >= 5) {
            CryptixDebug.debug("CipherInputStream", "... = " + n4);
        }
        return n4;
    }

    private int A(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        do {
            n5 = super.read(byArray, n4 += n5, n3 - n4);
            if (E < 7) continue;
            CryptixDebug.debug("CipherInputStream", "  n = " + n4 + ", k = " + n5);
        } while (n5 >= 0 && n4 < n3);
        return n4;
    }

    public synchronized int read() throws IOException {
        if (this.read(this.A, 0, 1) < 1) {
            return -1;
        }
        return this.A[0] & 0xFF;
    }

    public synchronized long skip(long l2) throws IOException {
        int n2 = 100000;
        int n3 = l2 < 100000L ? (int)l2 : 100000;
        byte[] byArray = new byte[n3];
        long l3 = l2;
        while (l3 > 0L) {
            if ((n3 = this.read(byArray, 0, n3)) < 0) {
                return l2 - l3;
            }
            n3 = (l3 -= (long)n3) < 100000L ? (int)l3 : 100000;
        }
        return l2;
    }

    public synchronized int available() throws IOException {
        if (this.F == null) {
            return 0;
        }
        return this.D + this.F.outBufferSize(super.available());
    }

    public synchronized void close() throws IOException {
        this.F = null;
        super.close();
    }

    public void mark(int n2) {
    }

    public void reset() throws IOException {
        throw new IOException("CipherInputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }
}

