/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.cryptix.provider.rsa.BaseRSAPrivateKey;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.DERUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.RSAFactors;

class E
extends BaseRSAPrivateKey {
    private byte[] J;

    E(CryptixRSAPrivateKey cryptixRSAPrivateKey) throws ClassCastException {
        RSAFactors rSAFactors = (RSAFactors)((Object)cryptixRSAPrivateKey);
        this.setRsaParams(cryptixRSAPrivateKey.getExponent(), rSAFactors.getP(), rSAFactors.getQ(), rSAFactors.getInverseOfQModP());
    }

    public E(RSAPrivateCrtKey rSAPrivateCrtKey) {
        this.setRsaParams(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E(String string, byte[] byArray, byte[] byArray2) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            SSLDebug.debug(8, "RSA Private key encoding", byArray2);
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            coderOperations.init(byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("RSAPrivateKey");
            aSNObject.accept(coderOperations, null);
            BigInteger bigInteger = (BigInteger)aSNObject.getComponent("RSAPrivateKey.privateExponent").getValue();
            BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.prime1").getValue();
            BigInteger bigInteger3 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.prime2").getValue();
            BigInteger bigInteger4 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.coefficient").getValue();
            SSLDebug.debug(8, "RSA Private decoded");
            this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
    }

    public byte[] getEncoded() {
        SSLDebug.debug(8, "Decoding private key");
        if (this.J != null) {
            return this.J;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BigInteger bigInteger = this.getP().subtract(new BigInteger("1"));
        BigInteger bigInteger2 = this.getQ().subtract(new BigInteger("1"));
        BigInteger bigInteger3 = this.getExponent().modInverse(bigInteger.multiply(bigInteger2));
        BigInteger bigInteger4 = this.getExponent().mod(bigInteger);
        BigInteger bigInteger5 = this.getExponent().mod(bigInteger2);
        try {
            DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getModulus(), byteArrayOutputStream);
            DERUtils.encodeInteger(bigInteger3, byteArrayOutputStream);
            DERUtils.encodeInteger(this.getExponent(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getP(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getQ(), byteArrayOutputStream);
            DERUtils.encodeInteger(bigInteger4, byteArrayOutputStream);
            DERUtils.encodeInteger(bigInteger5, byteArrayOutputStream);
            DERUtils.encodeInteger(this.getInverseOfQModP(), byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
            this.J = byteArrayOutputStream.toByteArray();
            return this.J;
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }

    public String getFormat() {
        return "X509";
    }
}

