/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.util;

import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class Hash {
    private MessageDigest A;

    public Hash(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.A = MessageDigest.getInstance(string, "CryptixEDT");
    }

    public int getSize() {
        return this.A.getDigestLength();
    }

    public void putBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        this.putInt(byArray.length);
        this.A.update(byArray);
    }

    public void putByte(byte by) {
        this.A.update(by);
    }

    public void putBytes(byte[] byArray) {
        this.A.update(byArray);
    }

    public void putInt(int n2) {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        try {
            byteArrayWriter.writeInt(n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.A.update(byteArrayWriter.toByteArray());
    }

    public void putString(String string) {
        this.putInt(string.length());
        this.A.update(string.getBytes());
    }

    public void reset() {
        this.A.reset();
    }

    public static byte[] simple(byte[] byArray, String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest messageDigest = MessageDigest.getInstance(string, "CryptixEDT");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public byte[] doFinal() {
        return this.A.digest();
    }
}

